/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.request;

import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicHeader;
import org.neo4j.ogm.authentication.CredentialsService;
import org.neo4j.ogm.authentication.HttpRequestAuthorization;
import org.neo4j.ogm.authentication.Neo4jCredentials;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.session.request.Neo4jRequest;
import org.neo4j.ogm.session.response.JsonResponse;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.ResultProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRequest
implements Neo4jRequest<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultRequest.class);
    private final CloseableHttpClient httpClient;
    private final Neo4jCredentials credentials;

    public DefaultRequest(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
        this.credentials = CredentialsService.userNameAndPassword();
    }

    public DefaultRequest(CloseableHttpClient httpClient, UsernamePasswordCredentials usernamePasswordCredentials) {
        this.httpClient = httpClient;
        this.credentials = usernamePasswordCredentials;
    }

    @Override
    public Neo4jResponse<String> execute(String url, String cypherQuery) {
        JsonResponse jsonResponse = null;
        try {
            LOGGER.debug("POST " + url + ", request: " + cypherQuery);
            HttpPost request = new HttpPost(url);
            StringEntity entity = new StringEntity(cypherQuery, "UTF-8");
            request.setHeader((Header)new BasicHeader("Content-Type", "application/json;charset=UTF-8"));
            request.setHeader((Header)new BasicHeader("Accept", "application/json;charset=UTF-8"));
            request.setHeader((Header)new BasicHeader("User-Agent", "neo4j-ogm.java/1.0"));
            HttpRequestAuthorization.authorize((HttpRequestBase)request, this.credentials);
            request.setEntity((HttpEntity)entity);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
            StatusLine statusLine = response.getStatusLine();
            HttpEntity responseEntity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (responseEntity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            LOGGER.debug("Response is OK, creating response handler");
            jsonResponse = new JsonResponse(response);
            return jsonResponse;
        }
        catch (Exception e) {
            LOGGER.warn("Caught response exception: " + e.getLocalizedMessage());
            if (jsonResponse != null) {
                jsonResponse.close();
            }
            throw new ResultProcessingException("Failed to execute request: " + cypherQuery, e);
        }
    }
}

