/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.transaction.SimpleTransaction;
import org.neo4j.ogm.session.transaction.Transaction;

public class TransactionsDelegate
implements Capability.Transactions {
    private final Neo4jSession session;
    private String autoCommitUrl;

    public TransactionsDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    public void autoCommit(String url) {
        if (url == null) {
            return;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.autoCommitUrl = url + "db/data/transaction/commit";
    }

    @Override
    public Transaction beginTransaction() {
        this.session.debug("beginTransaction() being called on thread: " + Thread.currentThread().getId());
        this.session.debug("Neo4jSession identity: " + this);
        Transaction tx = this.session.transactionManager().openTransaction(this.session.context());
        this.session.debug("Obtained new transaction: " + tx.url() + ", tx id: " + tx);
        return tx;
    }

    @Override
    public <T> T doInTransaction(GraphCallback<T> graphCallback) {
        return graphCallback.apply(this.session.requestHandler(), this.getCurrentOrAutocommitTransaction(), this.session.metaData());
    }

    @Override
    public Transaction getTransaction() {
        return this.session.transactionManager().getCurrentTransaction();
    }

    public Transaction getCurrentOrAutocommitTransaction() {
        this.session.debug("--------- new request ----------");
        this.session.debug("getOrCreateTransaction() being called on thread: " + Thread.currentThread().getId());
        this.session.debug("Session identity: " + this);
        Transaction tx = this.session.transactionManager().getCurrentTransaction();
        if (tx == null || tx.status().equals((Object)Transaction.Status.CLOSED) || tx.status().equals((Object)Transaction.Status.COMMITTED) || tx.status().equals((Object)Transaction.Status.ROLLEDBACK)) {
            this.session.debug("There is no existing transaction, creating a transient one");
            return new SimpleTransaction(this.session.context(), this.autoCommitUrl);
        }
        this.session.debug("Current transaction: " + tx.url() + ", tx id: " + tx);
        return tx;
    }
}

