/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Arrays;
import java.util.List;
import org.neo4j.ogm.cypher.compiler.CypherContext;
import org.neo4j.ogm.mapper.EntityGraphMapper;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.transaction.Transaction;

public class SaveDelegate
implements Capability.Save {
    private final Neo4jSession session;

    public SaveDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    @Override
    public <T> void save(T object) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.saveAll(object, -1);
        } else {
            this.save(object, -1);
        }
    }

    private <T> void saveAll(T object, int depth) {
        List<Object> list = object.getClass().isArray() ? Arrays.asList(object) : (List<Object>)object;
        for (Object e : list) {
            this.save(e, depth);
        }
    }

    @Override
    public <T> void save(T object, int depth) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.saveAll(object, depth);
        } else {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                Transaction tx = this.session.ensureTransaction();
                CypherContext context = new EntityGraphMapper(this.session.metaData(), this.session.context()).map(object, depth);
                try (Neo4jResponse<String> response = this.session.requestHandler().execute(context.getStatements(), tx.url());){
                    this.session.responseHandler().updateObjects(context, response, this.session.mapper());
                    tx.append(context);
                }
            } else {
                this.session.info(object.getClass().getName() + " is not an instance of a persistable class");
            }
        }
    }
}

