/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import org.neo4j.ogm.cypher.query.Query;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.response.Neo4jResponse;

public class LoadOneDelegate
implements Capability.LoadOne {
    private Neo4jSession session;

    public LoadOneDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        return this.load(type, id, 1);
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        String url = this.session.ensureTransaction().url();
        QueryStatements queryStatements = this.session.queryStatementsFor(type);
        Query qry = queryStatements.findOne(id, depth);
        try (Neo4jResponse<GraphModel> response = this.session.requestHandler().execute(qry, url);){
            T t = this.session.responseHandler().loadById(type, response, id);
            return t;
        }
    }
}

