/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Collection;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.GraphRowModelQuery;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.Query;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.metadata.RelationshipUtils;
import org.neo4j.ogm.metadata.info.AnnotationInfo;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.metadata.info.FieldInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.GraphRowModel;

public class LoadByTypeDelegate
implements Capability.LoadByType {
    private final Neo4jSession session;

    public LoadByTypeDelegate(Neo4jSession session) {
        this.session = session;
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        String url = this.session.ensureTransaction().url();
        String entityType = this.session.entityType(type.getName());
        QueryStatements queryStatements = this.session.queryStatementsFor(type);
        if (filters.isEmpty()) {
            Query qry = queryStatements.findByType(entityType, depth).setSortOrder(sortOrder).setPagination(pagination);
            try (Neo4jResponse<GraphModel> response = this.session.requestHandler().execute(qry, url);){
                Collection<T> collection = this.session.responseHandler().loadAll(type, response);
                return collection;
            }
        }
        filters = this.resolvePropertyAnnotations(type, filters);
        Query qry = queryStatements.findByProperties(entityType, filters, depth).setSortOrder(sortOrder).setPagination(pagination);
        if (depth != 0) {
            try (Neo4jResponse<GraphRowModel> response = this.session.requestHandler().execute((GraphRowModelQuery)qry, url);){
                Collection<T> collection = this.session.responseHandler().loadByProperty(type, response);
                return collection;
            }
        }
        try (Neo4jResponse<GraphModel> response = this.session.requestHandler().execute(qry, url);){
            Collection<T> collection = this.session.responseHandler().loadAll(type, response);
            return collection;
        }
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), new SortOrder(), pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters().add(filter), sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadAll(type, filters, new SortOrder(), null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadAll(type, filters, new SortOrder(), null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadAll(type, filters, sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadAll(type, filters, sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadAll(type, filters, new SortOrder(), pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadAll(type, filters, new SortOrder(), pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, filters, sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadAll(type, new Filters(), sortOrder, null, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, null, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadAll(type, new Filters(), new SortOrder(), paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadAll(type, new Filters(), sortOrder, pagination, depth);
    }

    private Filters resolvePropertyAnnotations(Class entityType, Filters filters) {
        for (Filter filter : filters) {
            if (filter.getOwnerEntityType() == null) {
                filter.setOwnerEntityType(entityType);
            }
            filter.setPropertyName(this.resolvePropertyName(filter.getOwnerEntityType(), filter.getPropertyName()));
            if (!filter.isNested()) continue;
            this.resolveRelationshipType(filter);
            ClassInfo nestedClassInfo = this.session.metaData().classInfo(filter.getNestedPropertyType().getName());
            filter.setNestedEntityTypeLabel(this.session.entityType(nestedClassInfo.name()));
            if (!this.session.metaData().isRelationshipEntity(nestedClassInfo.name())) continue;
            filter.setNestedRelationshipEntity(true);
        }
        return filters;
    }

    private String resolvePropertyName(Class entityType, String propertyName) {
        AnnotationInfo annotation;
        ClassInfo classInfo = this.session.metaData().classInfo(entityType.getName());
        FieldInfo fieldInfo = classInfo.propertyFieldByName(propertyName);
        if (fieldInfo != null && fieldInfo.getAnnotations() != null && (annotation = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.Property")) != null) {
            return annotation.get("name", propertyName);
        }
        return propertyName;
    }

    private void resolveRelationshipType(Filter parameter) {
        ClassInfo classInfo = this.session.metaData().classInfo(parameter.getOwnerEntityType().getName());
        FieldInfo fieldInfo = classInfo.relationshipFieldByName(parameter.getNestedPropertyName());
        String defaultRelationshipType = RelationshipUtils.inferRelationshipType(parameter.getNestedPropertyName());
        parameter.setRelationshipType(defaultRelationshipType);
        parameter.setRelationshipDirection("UNDIRECTED");
        if (fieldInfo.getAnnotations() != null) {
            AnnotationInfo annotation = fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotation != null) {
                parameter.setRelationshipType(annotation.get("type", defaultRelationshipType));
                parameter.setRelationshipDirection(annotation.get("direction", "UNDIRECTED"));
            }
            if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.StartNode") != null) {
                parameter.setRelationshipDirection("OUTGOING");
            }
            if (fieldInfo.getAnnotations().get("org.neo4j.ogm.annotation.EndNode") != null) {
                parameter.setRelationshipDirection("INCOMING");
            }
        }
    }
}

