/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.neo4j.ogm.cypher.query.RowModelQueryWithStatistics;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.QueryStatistics;
import org.neo4j.ogm.session.result.RowQueryStatisticsResult;

public class ExecuteStatementsDelegate
implements Capability.ExecuteStatements {
    private final Neo4jSession session;

    public ExecuteStatementsDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    @Override
    public QueryStatistics execute(String cypher, Map<String, Object> parameters) {
        if (StringUtils.isEmpty((String)cypher)) {
            throw new RuntimeException("Supplied cypher statement must not be null or empty.");
        }
        if (parameters == null) {
            throw new RuntimeException("Supplied Parameters cannot be null.");
        }
        this.assertNothingReturned(cypher);
        String url = this.session.ensureTransaction().url();
        RowModelQueryWithStatistics parameterisedStatement = new RowModelQueryWithStatistics(cypher, parameters);
        try (Neo4jResponse<RowQueryStatisticsResult> response = this.session.requestHandler().execute(parameterisedStatement, url);){
            RowQueryStatisticsResult result = response.next();
            QueryStatistics queryStatistics = result == null ? null : result.getStats();
            return queryStatistics;
        }
    }

    @Override
    public QueryStatistics execute(String statement) {
        if (StringUtils.isEmpty((String)statement)) {
            throw new RuntimeException("Supplied cypher statement must not be null or empty.");
        }
        this.assertNothingReturned(statement);
        RowModelQueryWithStatistics parameterisedStatement = new RowModelQueryWithStatistics(statement, Utils.map(new Object[0]));
        String url = this.session.ensureTransaction().url();
        try (Neo4jResponse<RowQueryStatisticsResult> response = this.session.requestHandler().execute(parameterisedStatement, url);){
            RowQueryStatisticsResult result = response.next();
            QueryStatistics queryStatistics = result == null ? null : result.getStats();
            return queryStatistics;
        }
    }

    private void assertNothingReturned(String cypher) {
        if (cypher.toUpperCase().contains(" RETURN ")) {
            throw new RuntimeException("execute() must not return data. Use query() instead.");
        }
    }
}

