/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.neo4j.ogm.cypher.query.GraphModelQuery;
import org.neo4j.ogm.cypher.query.RowModelQuery;
import org.neo4j.ogm.cypher.query.RowModelQueryWithStatistics;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.model.GraphModel;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.EntityRowModelMapper;
import org.neo4j.ogm.session.MapRowModelMapper;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.RowModelMapper;
import org.neo4j.ogm.session.Utils;
import org.neo4j.ogm.session.request.strategy.AggregateStatements;
import org.neo4j.ogm.session.response.Neo4jResponse;
import org.neo4j.ogm.session.result.QueryResult;
import org.neo4j.ogm.session.result.Result;
import org.neo4j.ogm.session.result.RowModel;
import org.neo4j.ogm.session.result.RowQueryStatisticsResult;

public class ExecuteQueriesDelegate
implements Capability.ExecuteQueries {
    private static final Pattern WRITE_CYPHER_KEYWORDS = Pattern.compile("\\b(CREATE|MERGE|SET|DELETE|REMOVE)\\b");
    private final Neo4jSession session;

    public ExecuteQueriesDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    @Override
    public <T> T queryForObject(Class<T> type, String cypher, Map<String, ?> parameters) {
        Iterable<T> results = this.query(type, cypher, parameters);
        int resultSize = Utils.size(results);
        if (resultSize < 1) {
            return null;
        }
        if (resultSize > 1) {
            throw new RuntimeException("Result not of expected size. Expected 1 row but found " + resultSize);
        }
        return results.iterator().next();
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.query(cypher, parameters, this.isReadOnly(cypher));
    }

    @Override
    public <T> Iterable<T> query(Class<T> type, String cypher, Map<String, ?> parameters) {
        this.validateQuery(cypher, parameters, false);
        if (type == null || type.equals(Void.class)) {
            throw new RuntimeException("Supplied type must not be null or void.");
        }
        return this.executeAndMap(type, cypher, parameters, new EntityRowModelMapper());
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        this.validateQuery(cypher, parameters, readOnly);
        if (readOnly) {
            return new QueryResult(this.executeAndMap(null, cypher, parameters, new MapRowModelMapper()), null);
        }
        String url = this.session.ensureTransaction().url();
        RowModelQueryWithStatistics parameterisedStatement = new RowModelQueryWithStatistics(cypher, parameters);
        try (Neo4jResponse<RowQueryStatisticsResult> response = this.session.requestHandler().execute(parameterisedStatement, url);){
            RowQueryStatisticsResult result = response.next();
            MapRowModelMapper rowModelMapper = new MapRowModelMapper();
            LinkedHashSet<Map<String, Object>> rowResult = new LinkedHashSet<Map<String, Object>>();
            for (List list : result.getRows()) {
                rowModelMapper.mapIntoResult(rowResult, list.toArray(), response.columns());
            }
            QueryResult queryResult = new QueryResult(rowResult, result.getStats());
            return queryResult;
        }
    }

    private <T> Iterable<T> executeAndMap(Class<T> type, String cypher, Map<String, ?> parameters, RowModelMapper<T> rowModelMapper) {
        if (StringUtils.isEmpty((String)cypher)) {
            throw new RuntimeException("Supplied cypher statement must not be null or empty.");
        }
        if (parameters == null) {
            throw new RuntimeException("Supplied Parameters cannot be null.");
        }
        String url = this.session.ensureTransaction().url();
        if (type != null && this.session.metaData().classInfo(type.getSimpleName()) != null) {
            GraphModelQuery qry = new GraphModelQuery(cypher, parameters);
            try (Neo4jResponse<GraphModel> response = this.session.requestHandler().execute(qry, url);){
                Collection<T> collection = this.session.responseHandler().loadAll(type, response);
                return collection;
            }
        }
        RowModelQuery qry = new RowModelQuery(cypher, parameters);
        try (Neo4jResponse<RowModel> response = this.session.requestHandler().execute(qry, url);){
            RowModel rowModel;
            String[] variables = response.columns();
            ArrayList result = new ArrayList();
            while ((rowModel = response.next()) != null) {
                rowModelMapper.mapIntoResult(result, rowModel.getValues(), variables);
            }
            ArrayList arrayList = result;
            return arrayList;
        }
    }

    @Override
    public long countEntitiesOfType(Class<?> entity) {
        ClassInfo classInfo = this.session.metaData().classInfo(entity.getName());
        if (classInfo == null) {
            return 0L;
        }
        RowModelQuery countStatement = new AggregateStatements().countNodesLabelledWith(classInfo.labels());
        String url = this.session.ensureTransaction().url();
        try (Neo4jResponse<RowModel> response = this.session.requestHandler().execute(countStatement, url);){
            RowModel queryResult = response.next();
            long l = queryResult == null ? 0L : ((Number)queryResult.getValues()[0]).longValue();
            return l;
        }
    }

    private boolean isReadOnly(String cypher) {
        Matcher matcher = WRITE_CYPHER_KEYWORDS.matcher(cypher.toUpperCase());
        return !matcher.find();
    }

    private void validateQuery(String cypher, Map<String, ?> parameters, boolean readOnly) {
        if (readOnly && !this.isReadOnly(cypher)) {
            throw new RuntimeException("Cypher query must not modify the graph if readOnly=true");
        }
        if (StringUtils.isEmpty((String)cypher)) {
            throw new RuntimeException("Supplied cypher statement must not be null or empty.");
        }
        if (parameters == null) {
            throw new RuntimeException("Supplied Parameters cannot be null.");
        }
    }
}

