/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session.delegates;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.neo4j.ogm.cypher.statement.ParameterisedStatement;
import org.neo4j.ogm.entityaccess.FieldWriter;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.session.Capability;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.request.strategy.DeleteNodeStatements;
import org.neo4j.ogm.session.request.strategy.DeleteRelationshipStatements;
import org.neo4j.ogm.session.request.strategy.DeleteStatements;
import org.neo4j.ogm.session.response.Neo4jResponse;

public class DeleteDelegate
implements Capability.Delete {
    private final Neo4jSession session;

    public DeleteDelegate(Neo4jSession neo4jSession) {
        this.session = neo4jSession;
    }

    private DeleteStatements getDeleteStatementsBasedOnType(Class type) {
        if (this.session.metaData().isRelationshipEntity(type.getName())) {
            return new DeleteRelationshipStatements();
        }
        return new DeleteNodeStatements();
    }

    private <T> void deleteAll(T object) {
        List<Object> list = object.getClass().isArray() ? Arrays.asList(object) : (List<Object>)object;
        for (Object e : list) {
            this.delete(e);
        }
    }

    @Override
    public <T> void delete(T object) {
        if (object.getClass().isArray() || Iterable.class.isAssignableFrom(object.getClass())) {
            this.deleteAll(object);
        } else {
            ClassInfo classInfo = this.session.metaData().classInfo(object);
            if (classInfo != null) {
                Field identityField = classInfo.getField(classInfo.identityField());
                Long identity = (Long)FieldWriter.read(identityField, object);
                if (identity != null) {
                    String url = this.session.ensureTransaction().url();
                    ParameterisedStatement request = this.getDeleteStatementsBasedOnType(object.getClass()).delete(identity);
                    try (Neo4jResponse<String> response = this.session.requestHandler().execute(request, url);){
                        this.session.context().clear(object);
                    }
                }
            } else {
                this.session.info(object.getClass().getName() + " is not an instance of a persistable class");
            }
        }
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        ClassInfo classInfo = this.session.metaData().classInfo(type.getName());
        if (classInfo != null) {
            String url = this.session.ensureTransaction().url();
            ParameterisedStatement request = this.getDeleteStatementsBasedOnType(type).deleteByType(this.session.entityType(classInfo.name()));
            try (Neo4jResponse<String> response = this.session.requestHandler().execute(request, url);){
                this.session.context().clear(type);
            }
        } else {
            this.session.info(type.getName() + " is not a persistable class");
        }
    }

    @Override
    public void purgeDatabase() {
        String url = this.session.ensureTransaction().url();
        this.session.requestHandler().execute(new DeleteNodeStatements().purge(), url).close();
        this.session.context().clear();
    }

    @Override
    public void clear() {
        this.session.context().clear();
    }
}

