/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.ogm.model.Property;

public class Utils {
    public static final Map<String, Object> map(final Object ... keysAndValues) {
        return new HashMap<String, Object>(){
            {
                for (int i = 0; i < keysAndValues.length; i += 2) {
                    this.put(String.valueOf(keysAndValues[i]), keysAndValues[i + 1]);
                }
            }
        };
    }

    public static final Map<String, Object> mapCollection(final String collectionName, final Collection<Property<String, Object>> properties) {
        return new HashMap<String, Object>(){
            {
                HashMap<String, Object> values = new HashMap<String, Object>();
                for (Property property : properties) {
                    String key = (String)property.getKey();
                    Object value = property.asParameter();
                    if (value == null) continue;
                    values.put(key, value);
                }
                this.put(collectionName, values);
            }
        };
    }

    public static int size(Iterable<?> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).size() : Utils.size(iterable.iterator());
    }

    public static int size(Iterator<?> iterator) {
        int count = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    public static Object coerceTypes(Class clazz, Object value) {
        if (("int".equals(clazz.getName()) || Integer.class.equals((Object)clazz)) && value.getClass().equals(Long.class)) {
            Long longValue = (Long)value;
            if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                throw new IllegalArgumentException(longValue + " cannot be cast to int without an overflow.");
            }
            return longValue.intValue();
        }
        if (("float".equals(clazz.getName()) || Float.class.equals((Object)clazz)) && value.getClass().equals(Double.class)) {
            Double dblValue = (Double)value;
            if (dblValue < -3.4028234663852886E38 || dblValue > 3.4028234663852886E38) {
                throw new IllegalArgumentException(dblValue + " cannot be cast to float without an overflow.");
            }
            return Float.valueOf(dblValue.floatValue());
        }
        if (("byte".equals(clazz.getName()) || Byte.class.equals((Object)clazz)) && value.getClass().equals(Integer.class)) {
            Integer intValue = (Integer)value;
            if (intValue < -128 || intValue > 127) {
                throw new IllegalArgumentException(intValue + " cannot be cast to byte without an overflow.");
            }
            return intValue.byteValue();
        }
        if (("double".equals(clazz.getName()) || Double.class.equals((Object)clazz)) && value.getClass().equals(Integer.class)) {
            Integer intValue = (Integer)value;
            if ((double)intValue.intValue() < -1.7976931348623157E308 || (double)intValue.intValue() > Double.MAX_VALUE) {
                throw new IllegalArgumentException(intValue + " cannot be cast to double without an overflow.");
            }
            return (double)intValue.intValue();
        }
        if (("long".equals(clazz.getName()) || Long.class.equals((Object)clazz)) && value.getClass().equals(Integer.class)) {
            Integer intValue = (Integer)value;
            return (long)intValue.intValue();
        }
        if (("double".equals(clazz.getName()) || Double.class.equals((Object)clazz)) && value.getClass().equals(Float.class)) {
            Float floatValue = (Float)value;
            return (double)floatValue.floatValue();
        }
        return value;
    }
}

