/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.Neo4jSession;
import org.neo4j.ogm.session.Session;

public class SessionFactory {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private final CloseableHttpClient httpClient = HttpClients.createDefault();
    private final MetaData metaData;

    public SessionFactory(String ... packages) {
        this.metaData = new MetaData(packages);
    }

    public Session openSession(String url) {
        try {
            URI uri = new URI(url);
            String username = null;
            String password = null;
            String uriStr = uri.toString();
            String auth = uri.getUserInfo();
            if (auth != null && !auth.trim().isEmpty()) {
                username = auth.split(":")[0];
                password = auth.split(":")[1];
                uriStr = uri.getScheme() + "://" + uri.toString().substring(uri.toString().indexOf(auth) + auth.length() + 1);
            }
            if (username != null && password != null) {
                return new Neo4jSession(this.metaData, uriStr, this.httpClient, objectMapper, new UsernamePasswordCredentials(username, password));
            }
            return new Neo4jSession(this.metaData, uriStr, this.httpClient, objectMapper);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public Session openSession(String url, String username, String password) {
        return new Neo4jSession(this.metaData, url, this.httpClient, objectMapper, new UsernamePasswordCredentials(username, password));
    }

    public MetaData metaData() {
        return this.metaData;
    }
}

