/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.session;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Map;
import org.apache.http.impl.client.CloseableHttpClient;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.neo4j.ogm.cypher.Filter;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;
import org.neo4j.ogm.mapper.MappingContext;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.session.GraphCallback;
import org.neo4j.ogm.session.Session;
import org.neo4j.ogm.session.delegates.DeleteDelegate;
import org.neo4j.ogm.session.delegates.ExecuteQueriesDelegate;
import org.neo4j.ogm.session.delegates.ExecuteStatementsDelegate;
import org.neo4j.ogm.session.delegates.GraphIdDelegate;
import org.neo4j.ogm.session.delegates.LoadByIdsDelegate;
import org.neo4j.ogm.session.delegates.LoadByInstancesDelegate;
import org.neo4j.ogm.session.delegates.LoadByTypeDelegate;
import org.neo4j.ogm.session.delegates.LoadOneDelegate;
import org.neo4j.ogm.session.delegates.SaveDelegate;
import org.neo4j.ogm.session.delegates.TransactionsDelegate;
import org.neo4j.ogm.session.request.DefaultRequest;
import org.neo4j.ogm.session.request.Neo4jRequest;
import org.neo4j.ogm.session.request.RequestHandler;
import org.neo4j.ogm.session.request.SessionRequestHandler;
import org.neo4j.ogm.session.request.strategy.QueryStatements;
import org.neo4j.ogm.session.request.strategy.VariableDepthQuery;
import org.neo4j.ogm.session.request.strategy.VariableDepthRelationshipQuery;
import org.neo4j.ogm.session.response.ResponseHandler;
import org.neo4j.ogm.session.response.SessionResponseHandler;
import org.neo4j.ogm.session.result.QueryStatistics;
import org.neo4j.ogm.session.result.Result;
import org.neo4j.ogm.session.transaction.Transaction;
import org.neo4j.ogm.session.transaction.TransactionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neo4jSession
implements Session {
    private final Logger logger = LoggerFactory.getLogger(Neo4jSession.class);
    private final MetaData metaData;
    private final MappingContext mappingContext;
    private final ObjectMapper mapper;
    private final TransactionManager txManager;
    private final LoadOneDelegate loadOneHandler = new LoadOneDelegate(this);
    private final LoadByTypeDelegate loadByTypeHandler = new LoadByTypeDelegate(this);
    private final LoadByIdsDelegate loadByIdsHandler = new LoadByIdsDelegate(this);
    private final LoadByInstancesDelegate loadByInstancesDelegate = new LoadByInstancesDelegate(this);
    private final SaveDelegate saveDelegate = new SaveDelegate(this);
    private final DeleteDelegate deleteDelegate = new DeleteDelegate(this);
    private final ExecuteQueriesDelegate executeQueriesDelegate = new ExecuteQueriesDelegate(this);
    private final ExecuteStatementsDelegate executeStatementsDelegate = new ExecuteStatementsDelegate(this);
    private final TransactionsDelegate transactionsDelegate = new TransactionsDelegate(this);
    private final GraphIdDelegate graphIdDelegate = new GraphIdDelegate(this);
    private Neo4jRequest<String> request;

    public Neo4jSession(MetaData metaData, String url, CloseableHttpClient client, ObjectMapper mapper) {
        this.metaData = metaData;
        this.mapper = mapper;
        this.mappingContext = new MappingContext(metaData);
        this.txManager = new TransactionManager(client, url);
        this.request = new DefaultRequest(client);
        this.transactionsDelegate.autoCommit(url);
    }

    public Neo4jSession(MetaData metaData, String url, CloseableHttpClient client, ObjectMapper mapper, UsernamePasswordCredentials credentials) {
        this.metaData = metaData;
        this.mapper = mapper;
        this.mappingContext = new MappingContext(metaData);
        this.txManager = new TransactionManager(client, url, credentials);
        this.request = new DefaultRequest(client, credentials);
        this.transactionsDelegate.autoCommit(url);
    }

    @Override
    public <T> T load(Class<T> type, Long id) {
        return this.loadOneHandler.load(type, id);
    }

    @Override
    public <T> T load(Class<T> type, Long id, int depth) {
        return this.loadOneHandler.load(type, id, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type) {
        return this.loadByTypeHandler.loadAll(type);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, int depth) {
        return this.loadByTypeHandler.loadAll(type, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging) {
        return this.loadByTypeHandler.loadAll(type, paging);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Pagination paging, int depth) {
        return this.loadByTypeHandler.loadAll(type, paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter) {
        return this.loadByTypeHandler.loadAll(type, filter);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filter filter, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filter, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters) {
        return this.loadByTypeHandler.loadAll(type, filters);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Filters filters, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByTypeHandler.loadAll(type, filters, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids) {
        return this.loadByIdsHandler.loadAll(type, ids);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging) {
        return this.loadByIdsHandler.loadAll(type, ids, paging);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, Pagination paging, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, paging, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Class<T> type, Collection<Long> ids, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByIdsHandler.loadAll(type, ids, sortOrder, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects) {
        return this.loadByInstancesDelegate.loadAll(objects, 1);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, pagination, depth);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination);
    }

    @Override
    public <T> Collection<T> loadAll(Collection<T> objects, SortOrder sortOrder, Pagination pagination, int depth) {
        return this.loadByInstancesDelegate.loadAll(objects, sortOrder, pagination, depth);
    }

    @Override
    public <T> T queryForObject(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.queryForObject(type, cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.query(cypher, parameters);
    }

    @Override
    public Result query(String cypher, Map<String, ?> parameters, boolean readOnly) {
        return this.executeQueriesDelegate.query(cypher, parameters, readOnly);
    }

    @Override
    public <T> Iterable<T> query(Class<T> type, String cypher, Map<String, ?> parameters) {
        return this.executeQueriesDelegate.query(type, cypher, parameters);
    }

    @Override
    public long countEntitiesOfType(Class<?> entity) {
        return this.executeQueriesDelegate.countEntitiesOfType(entity);
    }

    @Override
    public void purgeDatabase() {
        this.deleteDelegate.purgeDatabase();
    }

    @Override
    public void clear() {
        this.deleteDelegate.clear();
    }

    @Override
    public <T> void delete(T object) {
        this.deleteDelegate.delete(object);
    }

    @Override
    public <T> void deleteAll(Class<T> type) {
        this.deleteDelegate.deleteAll(type);
    }

    @Override
    public <T> void save(T object) {
        this.saveDelegate.save(object);
    }

    @Override
    public <T> void save(T object, int depth) {
        this.saveDelegate.save(object, depth);
    }

    @Override
    public QueryStatistics execute(String cypher, Map<String, Object> parameters) {
        return this.executeStatementsDelegate.execute(cypher, parameters);
    }

    @Override
    public QueryStatistics execute(String statement) {
        return this.executeStatementsDelegate.execute(statement);
    }

    @Override
    public Transaction beginTransaction() {
        return this.transactionsDelegate.beginTransaction();
    }

    @Override
    public <T> T doInTransaction(GraphCallback<T> graphCallback) {
        return this.transactionsDelegate.doInTransaction(graphCallback);
    }

    @Override
    public Transaction getTransaction() {
        return this.transactionsDelegate.getTransaction();
    }

    @Override
    public Long resolveGraphIdFor(Object possibleEntity) {
        return this.graphIdDelegate.resolveGraphIdFor(possibleEntity);
    }

    public QueryStatements queryStatementsFor(Class type) {
        if (this.metaData.isRelationshipEntity(type.getName())) {
            return new VariableDepthRelationshipQuery();
        }
        return new VariableDepthQuery();
    }

    public String entityType(String name) {
        return this.metaData.entityType(name);
    }

    public MappingContext context() {
        return this.mappingContext;
    }

    public MetaData metaData() {
        return this.metaData;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void setRequest(Neo4jRequest<String> neo4jRequest) {
        this.request = neo4jRequest;
    }

    public RequestHandler requestHandler() {
        return new SessionRequestHandler(this.mapper, this.request);
    }

    public Transaction ensureTransaction() {
        return this.transactionsDelegate.getCurrentOrAutocommitTransaction();
    }

    public ResponseHandler responseHandler() {
        return new SessionResponseHandler(this.metaData, this.mappingContext);
    }

    public TransactionManager transactionManager() {
        return this.txManager;
    }

    public void info(String msg) {
        this.logger.info(msg);
    }

    public void warn(String msg) {
        this.logger.warn(msg);
    }

    public void debug(String msg) {
        this.logger.debug(msg);
    }

    public void error(String msg) {
        this.logger.error(msg);
    }
}

