/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.model;

public class Property<K, V> {
    K key;
    V value;

    public static <K, V> Property<K, V> with(K key, V value) {
        return new Property<K, V>(key, value);
    }

    public Property() {
    }

    public Property(K key, V value) {
        this.key = key;
        this.value = value;
    }

    public K getKey() {
        return this.key;
    }

    public void setKey(K key) {
        this.key = key;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public String toString() {
        return String.format("%s : %s", this.key, this.asParameter());
    }

    public Object asParameter() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return this.value;
        }
        try {
            return Long.parseLong(this.value.toString());
        }
        catch (Exception e1) {
            try {
                return Double.parseDouble(this.value.toString());
            }
            catch (Exception e2) {
                return this.value.toString();
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (!this.key.equals(property.key)) {
            return false;
        }
        return this.value.equals(property.value);
    }

    public int hashCode() {
        int result = this.key.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }
}

