/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.model.Property;

public class NodeModel {
    Long id;
    String[] labels;
    List<Property<String, Object>> properties;

    public List<Property<String, Object>> getPropertyList() {
        return this.properties;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Property<String, Object> property : this.properties) {
            map.put(property.getKey(), property.getValue());
        }
        return map;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = new ArrayList<Property<String, Object>>();
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            this.properties.add(new Property<String, Object>(entry.getKey(), entry.getValue()));
        }
    }

    public void setPropertyList(List<Property<String, Object>> properties) {
        this.properties = properties;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String[] getLabels() {
        return this.labels;
    }

    public void setLabels(String[] labels) {
        this.labels = labels;
    }

    public Object property(String key) {
        for (Property<String, Object> property : this.properties) {
            if (!property.getKey().equals(key)) continue;
            return property.getValue();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodeModel nodeModel = (NodeModel)o;
        return this.id.equals(nodeModel.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }
}

