/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.model;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.model.NodeModel;
import org.neo4j.ogm.model.RelationshipModel;

public class GraphModel {
    private final Map<Long, NodeModel> nodeMap = new HashMap<Long, NodeModel>();
    private final Map<Long, RelationshipModel> relationshipMap = new HashMap<Long, RelationshipModel>();
    private Set<NodeModel> nodes = new LinkedHashSet<NodeModel>();
    private Set<RelationshipModel> relationships = new LinkedHashSet<RelationshipModel>();

    public Set<NodeModel> getNodes() {
        return this.nodes;
    }

    public void setNodes(NodeModel[] nodes) {
        for (NodeModel node : nodes) {
            this.nodes.add(node);
            this.nodeMap.put(node.getId(), node);
        }
    }

    public Set<RelationshipModel> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(RelationshipModel[] relationships) {
        for (RelationshipModel relationship : relationships) {
            this.relationships.add(relationship);
            this.relationshipMap.put(relationship.getId(), relationship);
        }
    }

    public NodeModel node(Long nodeId) {
        return this.nodeMap.get(nodeId);
    }

    public boolean containsNodeWithId(Long nodeId) {
        return this.nodeMap.containsKey(nodeId);
    }

    public boolean containsRelationshipWithId(Long relId) {
        return this.relationshipMap.containsKey(relId);
    }
}

