/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.info;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.info.AnnotationInfo;
import org.neo4j.ogm.typeconversion.AttributeConverter;
import org.neo4j.ogm.typeconversion.DateLongConverter;
import org.neo4j.ogm.typeconversion.DateStringConverter;
import org.neo4j.ogm.typeconversion.EnumStringConverter;
import org.neo4j.ogm.typeconversion.NumberStringConverter;

public class ObjectAnnotations {
    private String objectName;
    private final Map<String, AnnotationInfo> annotations = new HashMap<String, AnnotationInfo>();

    public String getName() {
        return this.objectName;
    }

    public void setName(String objectName) {
        this.objectName = objectName;
    }

    public void put(String key, AnnotationInfo value) {
        this.annotations.put(key, value);
    }

    public AnnotationInfo get(String key) {
        return this.annotations.get(key);
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    AttributeConverter<?, ?> getConverter() {
        AnnotationInfo customType = this.get("org.neo4j.ogm.annotation.typeconversion.Convert");
        if (customType != null) {
            String classDescriptor = customType.get("value", null);
            if (classDescriptor == null) {
                return null;
            }
            try {
                String className = classDescriptor.replace("/", ".").substring(1, classDescriptor.length() - 1);
                Class clazz = MetaDataClassLoader.loadClass(className);
                return (AttributeConverter)clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AnnotationInfo dateLongConverterInfo = this.get("org.neo4j.ogm.annotation.typeconversion.DateLong");
        if (dateLongConverterInfo != null) {
            return new DateLongConverter();
        }
        AnnotationInfo dateStringConverterInfo = this.get("org.neo4j.ogm.annotation.typeconversion.DateString");
        if (dateStringConverterInfo != null) {
            String format = dateStringConverterInfo.get("value", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
            return new DateStringConverter(format);
        }
        AnnotationInfo enumStringConverterInfo = this.get("org.neo4j.ogm.annotation.typeconversion.EnumString");
        if (enumStringConverterInfo != null) {
            String classDescriptor = enumStringConverterInfo.get("value", null);
            String className = classDescriptor.replace("/", ".").substring(1, classDescriptor.length() - 1);
            try {
                Class clazz = MetaDataClassLoader.loadClass(className);
                return new EnumStringConverter(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        AnnotationInfo numberStringConverterInfo = this.get("org.neo4j.ogm.annotation.typeconversion.NumberString");
        if (numberStringConverterInfo != null) {
            String classDescriptor = numberStringConverterInfo.get("value", null);
            String className = classDescriptor.replace("/", ".").substring(1, classDescriptor.length() - 1);
            try {
                Class clazz = MetaDataClassLoader.loadClass(className);
                return new NumberStringConverter(clazz);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }
}

