/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.info;

import java.util.Collection;
import org.neo4j.ogm.metadata.RelationshipUtils;
import org.neo4j.ogm.metadata.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.info.AnnotationInfo;
import org.neo4j.ogm.metadata.info.ObjectAnnotations;
import org.neo4j.ogm.typeconversion.AttributeConverter;

public class MethodInfo {
    private static final String primitiveGetters = "()I,()J,()S,()B,()C,()F,()D,()Z,()[I,()[J,()[S,()[B,()[C,()[F,()[D,()[Z";
    private static final String primitiveSetters = "(I)V,(J)V,(S)V,(B)V,(C)V,(F)V,(D)V,(Z)V,([I)V,([J)V,([S)V,([B)V,([C)V,([F)V,([D)V,([Z)V";
    private final String name;
    private final String descriptor;
    private final ObjectAnnotations annotations;
    private final String typeParameterDescriptor;
    private AttributeConverter<?, ?> converter;

    public MethodInfo(String name, String descriptor, String typeParameterDescriptor, ObjectAnnotations annotations) {
        this.name = name;
        this.descriptor = descriptor;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.annotations = annotations;
        if (!this.getAnnotations().isEmpty()) {
            this.setConverter(this.getAnnotations().getConverter());
        }
    }

    public String getName() {
        return this.name;
    }

    public String property() {
        if (this.isSimpleSetter() || this.isSimpleGetter()) {
            AnnotationInfo propertyAnnotation;
            if (this.annotations != null && (propertyAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Property")) != null) {
                return propertyAnnotation.get("name", this.getName());
            }
            if (this.name.startsWith("get") || this.name.startsWith("set")) {
                StringBuilder sb = new StringBuilder(this.name.substring(3));
                sb.setCharAt(0, Character.toLowerCase(sb.charAt(0)));
                return sb.toString();
            }
            return this.getName();
        }
        return null;
    }

    public String relationship() {
        if (!this.isSimpleSetter() && !this.isSimpleGetter()) {
            AnnotationInfo relationshipAnnotation;
            if (this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
                return relationshipAnnotation.get("type", RelationshipUtils.inferRelationshipType(this.getName()));
            }
            return RelationshipUtils.inferRelationshipType(this.getName());
        }
        return null;
    }

    public String relationshipTypeAnnotation() {
        AnnotationInfo relationshipAnnotation;
        if (!this.isSimpleSetter() && !this.isSimpleGetter() && this.annotations != null && (relationshipAnnotation = this.annotations.get("org.neo4j.ogm.annotation.Relationship")) != null) {
            return relationshipAnnotation.get("type", null);
        }
        return null;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String getTypeParameterDescriptor() {
        return this.typeParameterDescriptor;
    }

    public ObjectAnnotations getAnnotations() {
        return this.annotations;
    }

    public boolean isSimpleGetter() {
        return primitiveGetters.contains(this.descriptor) || this.hasConverter() || this.usesSimpleJavaTypes();
    }

    public boolean isSimpleSetter() {
        return primitiveSetters.contains(this.descriptor) || this.hasConverter() || this.usesSimpleJavaTypes();
    }

    private boolean usesSimpleJavaTypes() {
        return this.descriptor.contains("java/lang/") && this.typeParameterDescriptor == null || this.typeParameterDescriptor != null && this.typeParameterDescriptor.contains("java/lang/");
    }

    public AttributeConverter converter() {
        return this.converter;
    }

    public boolean hasConverter() {
        return this.converter != null;
    }

    public void setConverter(AttributeConverter<?, ?> converter) {
        if (this.converter == null && converter != null) {
            this.converter = converter;
        }
    }

    public String relationshipDirection(String defaultDirection) {
        if (this.relationship() != null) {
            AnnotationInfo annotationInfo = this.getAnnotations().get("org.neo4j.ogm.annotation.Relationship");
            if (annotationInfo == null) {
                return defaultDirection;
            }
            return annotationInfo.get("direction", defaultDirection);
        }
        throw new RuntimeException("relationship direction call invalid");
    }

    public boolean isTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "(L" + type.getName().replace(".", "/") + ";)V";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isParameterisedTypeOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "L" + type.getName().replace(".", "/") + ";";
            if (this.typeParameterDescriptor != null && this.typeParameterDescriptor.equals(typeSignature)) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isArrayOf(Class<?> type) {
        while (type != null) {
            String typeSignature = "([L" + type.getName().replace(".", "/") + ";)V";
            if (this.descriptor != null && this.descriptor.equals(typeSignature)) {
                return true;
            }
            type = type.getSuperclass();
        }
        return false;
    }

    public boolean isCollection() {
        String descriptorClass = this.getCollectionClassname();
        try {
            Class descriptorClazz = MetaDataClassLoader.loadClass(descriptorClass);
            if (Collection.class.isAssignableFrom(descriptorClazz)) {
                return true;
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return false;
    }

    public String getCollectionClassname() {
        String descriptorClass = this.descriptor.replace("/", ".");
        if (descriptorClass.startsWith("(L")) {
            descriptorClass = descriptorClass.substring(2, descriptorClass.length() - 3);
        }
        if (descriptorClass.startsWith("()L")) {
            descriptorClass = descriptorClass.substring(3, descriptorClass.length() - 1);
        }
        return descriptorClass;
    }

    public boolean isScalar() {
        if (this.typeParameterDescriptor != null) {
            return false;
        }
        return !this.descriptor.contains("[");
    }

    public boolean hasAnnotation(String annotationName) {
        return this.getAnnotations().get(annotationName) != null;
    }

    public boolean isArray() {
        return this.descriptor.startsWith("[");
    }

    public String getTypeDescriptor() {
        if (this.isScalar() || this.isArray()) {
            return this.descriptor;
        }
        return this.typeParameterDescriptor;
    }
}

