/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.info;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.info.ConstantPool;
import org.neo4j.ogm.metadata.info.InterfaceInfo;

public class InterfacesInfo {
    private final Map<String, InterfaceInfo> interfaceMap = new HashMap<String, InterfaceInfo>();

    InterfacesInfo() {
    }

    public InterfacesInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int interfaceCount = dataInputStream.readUnsignedShort();
        for (int i = 0; i < interfaceCount; ++i) {
            String interfaceName = constantPool.lookup(dataInputStream.readUnsignedShort()).replace('/', '.');
            this.interfaceMap.put(interfaceName, new InterfaceInfo(interfaceName));
        }
    }

    public Collection<InterfaceInfo> list() {
        return this.interfaceMap.values();
    }

    public InterfaceInfo get(String interfaceName) {
        return this.interfaceMap.get(interfaceName);
    }

    void add(InterfaceInfo interfaceInfo) {
        this.interfaceMap.put(interfaceInfo.name(), interfaceInfo);
    }

    public void append(InterfacesInfo interfacesInfo) {
        for (InterfaceInfo interfaceInfo : interfacesInfo.list()) {
            this.add(interfaceInfo);
        }
    }
}

