/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.info;

import java.io.DataInputStream;
import java.io.IOException;

class ConstantPool {
    private final Object[] pool;

    public ConstantPool(DataInputStream stream) throws IOException {
        int size = stream.readUnsignedShort();
        this.pool = new Object[size];
        block10: for (int i = 1; i < size; ++i) {
            int flag = stream.readUnsignedByte();
            switch (flag) {
                case 1: {
                    this.pool[i] = stream.readUTF();
                    continue block10;
                }
                case 3: 
                case 4: {
                    stream.skipBytes(4);
                    continue block10;
                }
                case 5: 
                case 6: {
                    stream.skipBytes(8);
                    ++i;
                    continue block10;
                }
                case 7: 
                case 8: {
                    this.pool[i] = stream.readUnsignedShort();
                    continue block10;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    stream.skipBytes(2);
                    this.pool[i] = stream.readUnsignedShort();
                    continue block10;
                }
                case 15: {
                    stream.skipBytes(3);
                    continue block10;
                }
                case 16: {
                    stream.skipBytes(2);
                    continue block10;
                }
                case 18: {
                    stream.skipBytes(4);
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("Unknown tag value for constant pool entry: " + flag);
                }
            }
        }
    }

    public String lookup(int entry) {
        Object constantPoolObj = this.pool[entry];
        return constantPoolObj instanceof Integer ? (String)this.pool[(Integer)constantPoolObj] : (String)constantPoolObj;
    }
}

