/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.info;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.info.AnnotationInfo;
import org.neo4j.ogm.metadata.info.ConstantPool;

public class AnnotationsInfo {
    private final Map<String, AnnotationInfo> classAnnotations = new HashMap<String, AnnotationInfo>();

    AnnotationsInfo() {
    }

    public AnnotationsInfo(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException {
        int attributesCount = dataInputStream.readUnsignedShort();
        for (int i = 0; i < attributesCount; ++i) {
            String attributeName = constantPool.lookup(dataInputStream.readUnsignedShort());
            int attributeLength = dataInputStream.readInt();
            if ("RuntimeVisibleAnnotations".equals(attributeName)) {
                int annotationCount = dataInputStream.readUnsignedShort();
                for (int m = 0; m < annotationCount; ++m) {
                    AnnotationInfo info = new AnnotationInfo(dataInputStream, constantPool);
                    this.classAnnotations.put(info.getName(), info);
                }
                continue;
            }
            dataInputStream.skipBytes(attributeLength);
        }
    }

    public Collection<AnnotationInfo> list() {
        return this.classAnnotations.values();
    }

    public AnnotationInfo get(String annotationName) {
        return this.classAnnotations.get(annotationName);
    }

    void add(AnnotationInfo annotationInfo) {
        this.classAnnotations.put(annotationInfo.getName(), annotationInfo);
    }

    public void append(AnnotationsInfo annotationsInfo) {
        for (AnnotationInfo annotationInfo : annotationsInfo.list()) {
            this.add(annotationInfo);
        }
    }
}

