/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata.classloader;

import org.neo4j.ogm.metadata.classloader.DefaultStrategy;
import org.neo4j.ogm.metadata.classloader.Strategy;

abstract class Resolver {
    private static Strategy strategy;
    private static final CallerResolver CALLER_RESOLVER;

    Resolver() {
    }

    static synchronized ClassLoader resolve() {
        return strategy.classLoader(Resolver.callingClass());
    }

    private static Class callingClass() {
        return CALLER_RESOLVER.getClassContext()[4];
    }

    static {
        try {
            CALLER_RESOLVER = new CallerResolver();
            strategy = new DefaultStrategy();
        }
        catch (SecurityException se) {
            throw new RuntimeException(se);
        }
    }

    private static final class CallerResolver
    extends SecurityManager {
        private CallerResolver() {
        }

        protected Class[] getClassContext() {
            return super.getClassContext();
        }
    }
}

