/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.neo4j.ogm.annotation.NodeEntity;
import org.neo4j.ogm.annotation.RelationshipEntity;
import org.neo4j.ogm.metadata.AmbiguousBaseClassException;
import org.neo4j.ogm.metadata.info.AnnotationInfo;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.metadata.info.DomainInfo;
import org.neo4j.ogm.typeconversion.ConversionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetaData {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaData.class);
    private final DomainInfo domainInfo;

    public MetaData(String ... packages) {
        this.domainInfo = new DomainInfo(packages);
    }

    public ClassInfo classInfo(String name) {
        ClassInfo classInfo = this._classInfo(name, NodeEntity.class.getName(), "label");
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = this._classInfo(name, RelationshipEntity.class.getName(), "type");
        if (classInfo != null) {
            return classInfo;
        }
        classInfo = this.domainInfo.getClassSimpleName(name);
        if (classInfo != null) {
            return classInfo;
        }
        return null;
    }

    public ClassInfo classInfo(Object object) {
        return this.classInfo(object.getClass().getName());
    }

    private ClassInfo _classInfo(String name, String nodeEntityAnnotation, String annotationPropertyName) {
        List<ClassInfo> labelledClasses = this.domainInfo.getClassInfosWithAnnotation(nodeEntityAnnotation);
        if (labelledClasses != null) {
            for (ClassInfo labelledClass : labelledClasses) {
                AnnotationInfo annotationInfo = labelledClass.annotationsInfo().get(nodeEntityAnnotation);
                String value = annotationInfo.get(annotationPropertyName, labelledClass.neo4jName());
                if (!value.equals(name)) continue;
                return labelledClass;
            }
        }
        return null;
    }

    private Set<ClassInfo> _classInfos(String name, String nodeEntityAnnotation, String annotationPropertyName) {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        List<ClassInfo> labelledClasses = this.domainInfo.getClassInfosWithAnnotation(nodeEntityAnnotation);
        if (labelledClasses != null) {
            for (ClassInfo labelledClass : labelledClasses) {
                AnnotationInfo annotationInfo = labelledClass.annotationsInfo().get(nodeEntityAnnotation);
                String value = annotationInfo.get(annotationPropertyName, labelledClass.neo4jName());
                if (!value.equals(name)) continue;
                classInfos.add(labelledClass);
            }
        }
        return classInfos;
    }

    public ClassInfo resolve(String ... taxa) {
        if (taxa.length > 0) {
            HashSet<ClassInfo> baseClasses = new HashSet<ClassInfo>();
            for (String taxon : taxa) {
                ClassInfo taxonClassInfo = this.classInfo(taxon);
                if (taxonClassInfo == null) continue;
                ClassInfo superclassInfo = this.classInfo(taxonClassInfo.superclassName());
                if (baseClasses.contains(superclassInfo)) {
                    baseClasses.remove(superclassInfo);
                    baseClasses.add(taxonClassInfo);
                    continue;
                }
                ClassInfo baseClassInfo = this.findSingleBaseClass(taxonClassInfo, taxonClassInfo.directSubclasses());
                if (baseClassInfo != null && !baseClasses.contains(baseClassInfo)) {
                    baseClasses.add(taxonClassInfo);
                    continue;
                }
                ClassInfo singleImplementor = this.findSingleImplementor(taxon);
                if (singleImplementor == null) continue;
                baseClasses.add(singleImplementor);
            }
            if (baseClasses.size() > 1) {
                throw new AmbiguousBaseClassException(Arrays.toString(taxa));
            }
            if (baseClasses.iterator().hasNext()) {
                return (ClassInfo)baseClasses.iterator().next();
            }
        }
        return null;
    }

    public Set<ClassInfo> classInfoByLabelOrType(String name) {
        HashSet<ClassInfo> classInfos = new HashSet<ClassInfo>();
        ClassInfo classInfo = this._classInfo(name, NodeEntity.class.getName(), "label");
        if (classInfo != null) {
            classInfos.add(classInfo);
        }
        for (ClassInfo info : this._classInfos(name, RelationshipEntity.class.getName(), "type")) {
            classInfos.add(info);
        }
        classInfo = this.domainInfo.getClassSimpleName(name);
        if (classInfo != null) {
            classInfos.add(classInfo);
        }
        return classInfos;
    }

    private ClassInfo findSingleBaseClass(ClassInfo fqn, List<ClassInfo> classInfoList) {
        if (classInfoList.isEmpty()) {
            if (fqn.isInterface()) {
                return null;
            }
            return fqn;
        }
        if (classInfoList.size() > 1) {
            LOGGER.debug("More than one class subclasses " + fqn);
            return null;
        }
        ClassInfo classInfo = classInfoList.iterator().next();
        return this.findSingleBaseClass(classInfo, classInfo.directSubclasses());
    }

    public boolean isRelationshipEntity(String className) {
        ClassInfo classInfo = this.classInfo(className);
        if (classInfo == null) {
            return false;
        }
        return null != classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity");
    }

    private ClassInfo findSingleImplementor(String taxon) {
        ClassInfo interfaceInfo = this.domainInfo.getClassInfoForInterface(taxon);
        if (interfaceInfo != null && interfaceInfo.directImplementingClasses() != null && interfaceInfo.directImplementingClasses().size() == 1) {
            return interfaceInfo.directImplementingClasses().get(0);
        }
        return null;
    }

    public Collection<ClassInfo> persistentEntities() {
        return this.domainInfo.getClassInfoMap().values();
    }

    public String entityType(String name) {
        ClassInfo classInfo = this.classInfo(name);
        if (this.isRelationshipEntity(classInfo.name())) {
            AnnotationInfo annotation = classInfo.annotationsInfo().get("org.neo4j.ogm.annotation.RelationshipEntity");
            return annotation.get("type", classInfo.name());
        }
        return classInfo.neo4jName();
    }

    public List<ClassInfo> getImplementingClassInfos(String interfaceName) {
        return this.domainInfo.getClassInfos(interfaceName);
    }

    public void registerConversionCallback(ConversionCallback conversionCallback) {
        this.domainInfo.registerConversionCallback(conversionCallback);
    }
}

