/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.metadata;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.metadata.classloader.MetaDataClassLoader;

public abstract class ClassUtils {
    private static final Map<String, Class<?>> PRIMITIVE_TYPE_MAP = new HashMap<String, Class<?>>(){
        {
            this.put("Z", Boolean.TYPE);
            this.put("B", Byte.TYPE);
            this.put("C", Character.TYPE);
            this.put("D", Double.TYPE);
            this.put("F", Float.TYPE);
            this.put("I", Integer.TYPE);
            this.put("J", Long.TYPE);
            this.put("S", Short.TYPE);
        }
    };

    public static Class<?> getType(String descriptor) {
        String typeName;
        if (descriptor.startsWith("()")) {
            return ClassUtils.getType(descriptor.substring(2));
        }
        int p = descriptor.indexOf("(");
        int q = descriptor.indexOf(")");
        if (!descriptor.contains("[")) {
            if (descriptor.endsWith(";)V")) {
                --q;
            }
            if (descriptor.startsWith("(L")) {
                ++p;
            }
            if (descriptor.startsWith("L")) {
                ++p;
                q = descriptor.length() - 1;
            }
        }
        if (descriptor.startsWith("[")) {
            p = 0;
            q = 2;
        }
        if (descriptor.startsWith("[L")) {
            p = 1;
            q = descriptor.length() - 1;
        }
        if (descriptor.length() == 1) {
            q = 1;
        }
        if (q == p + 1) {
            p = q + 1;
            q = descriptor.length() - 1;
        }
        if ((typeName = descriptor.substring(p + 1, q).replace("/", ".")).length() == 1) {
            return PRIMITIVE_TYPE_MAP.get(typeName);
        }
        try {
            return MetaDataClassLoader.loadClass(typeName);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public static Set<File> getUniqueClasspathElements(List<String> classPaths) {
        HashSet<File> pathFiles = new HashSet<File>();
        for (String classPath : classPaths) {
            try {
                Enumeration<URL> resources = ClassUtils.class.getClassLoader().getResources(classPath.replace(".", "/"));
                while (resources.hasMoreElements()) {
                    URL resource = resources.nextElement();
                    if (resource.getProtocol().equals("file")) {
                        pathFiles.add(new File(resource.toURI()));
                        continue;
                    }
                    if (!resource.getProtocol().equals("jar")) continue;
                    String jarPath = resource.getPath().substring(5, resource.getPath().indexOf("!"));
                    pathFiles.add(new File(jarPath));
                }
            }
            catch (IOException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return pathFiles;
    }
}

