/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.mapper;

import java.util.Map;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.mapper.MappedRelationship;

public class TransientRelationship {
    private final String src;
    private final String tgt;
    private final String ref;
    private final String rel;
    private final Class srcClass;
    private final Class tgtClass;

    public TransientRelationship(String src, String ref, String rel, String tgt, Class srcClass, Class tgtClass) {
        this.src = src;
        this.tgt = tgt;
        this.ref = ref;
        this.rel = rel;
        this.srcClass = srcClass;
        this.tgtClass = tgtClass;
    }

    public MappedRelationship convert(Map<String, Long> refMap) {
        Long relIdentity;
        Long srcIdentity = this.src.startsWith("_") ? refMap.get(this.src) : Long.valueOf(Long.parseLong(this.src.substring(1)));
        Long tgtIdentity = this.tgt.startsWith("_") ? refMap.get(this.tgt) : Long.valueOf(Long.parseLong(this.tgt.substring(1)));
        Long l = relIdentity = this.ref.startsWith("_") ? refMap.get(this.ref) : Long.valueOf(Long.parseLong(this.ref.substring(1)));
        if (srcIdentity == null) {
            throw new RuntimeException("Couldn't get identity for " + this.src);
        }
        if (tgtIdentity == null) {
            throw new RuntimeException("Couldn't get identity for " + this.tgt);
        }
        if (relIdentity == null) {
            throw new RuntimeException("Couldn't get identity for " + this.ref);
        }
        return new MappedRelationship(srcIdentity, this.rel, tgtIdentity, relIdentity, this.srcClass, this.tgtClass);
    }

    public boolean equalsIgnoreDirection(String src, RelationshipBuilder builder, String tgt) {
        Boolean singleton = builder.isSingleton();
        if (this.rel.equals(builder.getType()) && singleton.booleanValue()) {
            if (this.src.equals(src) && this.tgt.equals(tgt)) {
                return true;
            }
            if (this.src.equals(tgt) && this.tgt.equals(src)) {
                return true;
            }
        }
        return false;
    }
}

