/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.mapper;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.entityaccess.DefaultEntityAccessStrategy;
import org.neo4j.ogm.entityaccess.EntityAccess;
import org.neo4j.ogm.entityaccess.EntityAccessStrategy;
import org.neo4j.ogm.entityaccess.EntityFactory;
import org.neo4j.ogm.entityaccess.PropertyReader;
import org.neo4j.ogm.entityaccess.PropertyWriter;
import org.neo4j.ogm.metadata.MappingException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.session.result.RowModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUseEntityMapper {
    private static final Logger logger = LoggerFactory.getLogger(SingleUseEntityMapper.class);
    private final EntityAccessStrategy entityAccessStrategy;
    private final EntityFactory entityFactory;
    private final MetaData metadata;

    public SingleUseEntityMapper(MetaData mappingMetaData, EntityFactory entityFactory) {
        this.metadata = mappingMetaData;
        this.entityFactory = new EntityFactory(mappingMetaData);
        this.entityAccessStrategy = new DefaultEntityAccessStrategy();
    }

    public <T> T map(Class<T> type, String[] columnNames, RowModel rowModel) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (int i = 0; i < rowModel.getValues().length; ++i) {
            properties.put(columnNames[i], rowModel.getValues()[i]);
        }
        T entity = this.entityFactory.newObject(type);
        this.setPropertiesOnEntity(entity, properties);
        return entity;
    }

    private void setPropertiesOnEntity(Object entity, Map<String, Object> propertyMap) {
        ClassInfo classInfo = this.resolveClassInfoFor(entity.getClass());
        for (Map.Entry<String, Object> propertyMapEntry : propertyMap.entrySet()) {
            this.writeProperty(classInfo, entity, propertyMapEntry);
        }
    }

    private ClassInfo resolveClassInfoFor(Class<?> type) {
        ClassInfo classInfo = this.metadata.classInfo(type.getSimpleName());
        if (classInfo != null) {
            return classInfo;
        }
        throw new MappingException("Error mapping to ad-hoc " + type + ".  At present, only @QueryResult types that are discovered by the domain entity package scanning can be mapped.");
    }

    private void writeProperty(ClassInfo classInfo, Object instance, Map.Entry<String, Object> property) {
        PropertyWriter writer = this.entityAccessStrategy.getPropertyWriter(classInfo, property.getKey());
        if (writer == null) {
            logger.warn("Unable to find property: {} on class: {} for writing", (Object)property.getKey(), (Object)classInfo.name());
        } else {
            PropertyReader reader;
            Object value = property.getValue();
            if ((writer.type().isArray() || Iterable.class.isAssignableFrom(writer.type())) && (reader = this.entityAccessStrategy.getPropertyReader(classInfo, property.getKey().toString())) != null) {
                Object currentValue = reader.read(instance);
                Class<?> paramType = writer.type();
                value = paramType.isArray() ? EntityAccess.merge(paramType, (Iterable)value, (Object[])currentValue) : EntityAccess.merge(paramType, (Iterable)value, (Iterable)currentValue);
            }
            writer.write(instance, value);
        }
    }
}

