/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.mapper;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.neo4j.ogm.entityaccess.DefaultEntityAccessStrategy;
import org.neo4j.ogm.entityaccess.EntityAccessStrategy;
import org.neo4j.ogm.entityaccess.PropertyReader;
import org.neo4j.ogm.entityaccess.RelationalReader;
import org.neo4j.ogm.mapper.EntityMemo;
import org.neo4j.ogm.mapper.MappedRelationship;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingContext {
    private final Logger logger = LoggerFactory.getLogger(MappingContext.class);
    private final ConcurrentMap<Long, Object> relationshipEntityRegister = new ConcurrentHashMap<Long, Object>();
    private final ConcurrentMap<Long, Object> nodeEntityRegister = new ConcurrentHashMap<Long, Object>();
    private final Set<MappedRelationship> relationshipRegister = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ConcurrentMap<Class<?>, Set<Object>> typeRegister = new ConcurrentHashMap();
    private final EntityMemo objectMemo = new EntityMemo();
    private final MetaData metaData;
    private final EntityAccessStrategy entityAccessStrategy = new DefaultEntityAccessStrategy();

    public MappingContext(MetaData metaData) {
        this.metaData = metaData;
    }

    public Object getNodeEntity(Long id) {
        return this.nodeEntityRegister.get(id);
    }

    public Object registerNodeEntity(Object entity, Long id) {
        this.nodeEntityRegister.putIfAbsent(id, entity);
        entity = this.nodeEntityRegister.get(id);
        this.registerTypes(entity.getClass(), entity);
        return entity;
    }

    private void registerTypes(Class type, Object entity) {
        this.getAll(type).add(entity);
        if (type.getSuperclass() != null && this.metaData != null && this.metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            this.registerTypes(type.getSuperclass(), entity);
        }
        if (type.getInterfaces() != null && this.metaData != null) {
            for (Class<?> interfaceClass : type.getInterfaces()) {
                if (this.metaData.classInfo(interfaceClass.getName()) == null) continue;
                this.registerTypes(interfaceClass, entity);
            }
        }
    }

    private void deregisterTypes(Class type, Object entity) {
        Set entities = (Set)this.typeRegister.get(type);
        if (entities != null && type.getSuperclass() != null && this.metaData != null && this.metaData.classInfo(type.getSuperclass().getName()) != null && !type.getSuperclass().getName().equals("java.lang.Object")) {
            entities.remove(entity);
            this.deregisterTypes(type.getSuperclass(), entity);
        }
    }

    public void deregister(Object entity, Long id) {
        this.deregisterTypes(entity.getClass(), entity);
        this.nodeEntityRegister.remove(id);
    }

    public void replace(Object entity, Long id) {
        this.nodeEntityRegister.remove(id);
        this.registerNodeEntity(entity, id);
        this.remember(entity);
    }

    public Set<Object> getAll(Class<?> type) {
        Set objectList = (Set)this.typeRegister.get(type);
        if (objectList == null) {
            this.typeRegister.putIfAbsent(type, Collections.synchronizedSet(new HashSet()));
            objectList = (Set)this.typeRegister.get(type);
        }
        return objectList;
    }

    public void remember(Object entity) {
        this.objectMemo.remember(entity, this.metaData.classInfo(entity));
    }

    public boolean isDirty(Object entity) {
        ClassInfo classInfo = this.metaData.classInfo(entity);
        return !this.objectMemo.remembered(entity, classInfo);
    }

    public boolean isRegisteredRelationship(MappedRelationship relationship) {
        return this.relationshipRegister.contains(relationship);
    }

    public Set<MappedRelationship> mappedRelationships() {
        return this.relationshipRegister;
    }

    public void registerRelationship(MappedRelationship relationship) {
        if (relationship.getRelationshipId() != null && this.relationshipEntityRegister.get(relationship.getRelationshipId()) == null) {
            relationship.setRelationshipId(null);
        }
        this.relationshipRegister.add(relationship);
    }

    public void clear() {
        this.objectMemo.clear();
        this.relationshipRegister.clear();
        this.nodeEntityRegister.clear();
        this.typeRegister.clear();
        this.relationshipEntityRegister.clear();
    }

    public Object getRelationshipEntity(Long relationshipId) {
        return this.relationshipEntityRegister.get(relationshipId);
    }

    public Object registerRelationshipEntity(Object relationshipEntity, Long id) {
        this.relationshipEntityRegister.putIfAbsent(id, relationshipEntity);
        this.registerTypes(relationshipEntity.getClass(), relationshipEntity);
        return relationshipEntity;
    }

    public void clear(Class<?> type) {
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        if (classInfo.isInterface()) {
            List<ClassInfo> implementingClasses = this.metaData.getImplementingClassInfos(classInfo.name());
            for (ClassInfo implementingClass : implementingClasses) {
                try {
                    String implementingClassName = implementingClass.name();
                    this.clear(MetaDataClassLoader.loadClass(implementingClassName));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else {
            PropertyReader identityReader = this.entityAccessStrategy.getIdentityPropertyReader(classInfo);
            this.clear(type, identityReader);
        }
    }

    private void clear(Class<?> type, PropertyReader identityReader) {
        for (Object entity : this.getAll(type)) {
            this.purge(entity, identityReader);
        }
        this.getAll(type).clear();
    }

    public void clear(Object entity) {
        Class<?> type = entity.getClass();
        ClassInfo classInfo = this.metaData.classInfo(type.getName());
        PropertyReader identityReader = this.entityAccessStrategy.getIdentityPropertyReader(classInfo);
        this.purge(entity, identityReader);
        this.getAll(type).remove(entity);
    }

    private void purge(Object entity, PropertyReader identityReader) {
        Long id = (Long)identityReader.read(entity);
        if (id != null) {
            if (this.nodeEntityRegister.containsValue(entity)) {
                this.nodeEntityRegister.remove(id);
                Iterator<MappedRelationship> mappedRelationshipIterator = this.mappedRelationships().iterator();
                while (mappedRelationshipIterator.hasNext()) {
                    MappedRelationship mappedRelationship = mappedRelationshipIterator.next();
                    if (mappedRelationship.getStartNodeId() != id.longValue() && mappedRelationship.getEndNodeId() != id.longValue()) continue;
                    mappedRelationshipIterator.remove();
                }
            }
            if (this.relationshipEntityRegister.containsValue(entity)) {
                this.relationshipEntityRegister.remove(id);
                RelationalReader startNodeReader = this.entityAccessStrategy.getStartNodeReader(this.metaData.classInfo(entity));
                this.clear(startNodeReader.read(entity));
                RelationalReader endNodeReader = this.entityAccessStrategy.getEndNodeReader(this.metaData.classInfo(entity));
                this.clear(endNodeReader.read(entity));
            }
        }
    }

    public void dump() {
        boolean remembered;
        for (Object o : this.nodeEntityRegister.values()) {
            remembered = this.objectMemo.contains(o);
            System.out.println(String.format("%s, %s", o, remembered));
        }
        for (Object o : this.relationshipEntityRegister.values()) {
            remembered = this.objectMemo.contains(o);
            System.out.println(String.format("%s, %s", o, remembered));
        }
    }
}

