/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.mapper;

public class MappedRelationship {
    private final long startNodeId;
    private final String relationshipType;
    private final long endNodeId;
    private Long relationshipId;
    private Class startNodeType;
    private Class endNodeType;
    private boolean active = true;

    public MappedRelationship(long startNodeId, String relationshipType, long endNodeId, Class startNodeType, Class endNodeType) {
        this.startNodeId = startNodeId;
        this.relationshipType = relationshipType;
        this.endNodeId = endNodeId;
        this.startNodeType = startNodeType;
        this.endNodeType = endNodeType;
    }

    public MappedRelationship(long startNodeId, String relationshipType, long endNodeId, Long relationshipId, Class startNodeType, Class endNodeType) {
        this.startNodeId = startNodeId;
        this.relationshipType = relationshipType;
        this.endNodeId = endNodeId;
        this.relationshipId = relationshipId;
        this.startNodeType = startNodeType;
        this.endNodeType = endNodeType;
    }

    public long getStartNodeId() {
        return this.startNodeId;
    }

    public String getRelationshipType() {
        return this.relationshipType;
    }

    public long getEndNodeId() {
        return this.endNodeId;
    }

    public Long getRelationshipId() {
        return this.relationshipId;
    }

    public void setRelationshipId(Long relationshipId) {
        this.relationshipId = relationshipId;
    }

    public void activate() {
        this.active = true;
    }

    public void deactivate() {
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    public Class getEndNodeType() {
        return this.endNodeType;
    }

    public Class getStartNodeType() {
        return this.startNodeType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappedRelationship that = (MappedRelationship)o;
        if (this.startNodeId != that.startNodeId) {
            return false;
        }
        if (this.endNodeId != that.endNodeId) {
            return false;
        }
        if (!this.relationshipType.equals(that.relationshipType)) {
            return false;
        }
        return !(this.relationshipId == null ? that.relationshipId != null : !this.relationshipId.equals(that.relationshipId));
    }

    public int hashCode() {
        int result = (int)(this.startNodeId ^ this.startNodeId >>> 32);
        result = 31 * result + this.relationshipType.hashCode();
        result = 31 * result + (int)(this.endNodeId ^ this.endNodeId >>> 32);
        result = 31 * result + (this.relationshipId != null ? this.relationshipId.hashCode() : 0);
        return result;
    }
}

