/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.mapper;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.ogm.entityaccess.FieldWriter;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.metadata.info.FieldInfo;

public class EntityMemo {
    private final Map<Object, Long> objectHash = new ConcurrentHashMap<Object, Long>();
    private static final long seed = -197749L;

    public void remember(Object object, ClassInfo classInfo) {
        this.objectHash.put(object, EntityMemo.hash(object, classInfo));
    }

    public boolean remembered(Object object, ClassInfo classInfo) {
        long expected;
        if (!this.objectHash.containsKey(object)) {
            return false;
        }
        long actual = EntityMemo.hash(object, classInfo);
        return actual == (expected = this.objectHash.get(object).longValue());
    }

    public void clear() {
        this.objectHash.clear();
    }

    public boolean contains(Object o) {
        return this.objectHash.containsKey(o);
    }

    private static long hash(Object object, ClassInfo classInfo) {
        long hash = -197749L;
        for (FieldInfo fieldInfo : classInfo.propertyFields()) {
            Field field = classInfo.getField(fieldInfo);
            Object value = FieldWriter.read(field, object);
            if (value == null) continue;
            hash = hash * 31L + EntityMemo.hash(value.toString());
        }
        return hash;
    }

    private static long hash(String string) {
        long h = 1125899906842597L;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            h = 31L * h + (long)string.charAt(i);
        }
        return h;
    }
}

