/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entityaccess;

import java.lang.reflect.Method;
import org.neo4j.ogm.entityaccess.EntityAccess;
import org.neo4j.ogm.entityaccess.EntityAccessException;
import org.neo4j.ogm.metadata.ClassUtils;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.metadata.info.MethodInfo;
import org.neo4j.ogm.session.Utils;

public class MethodWriter
extends EntityAccess {
    private final MethodInfo setterMethodInfo;
    private final Class<?> parameterType;
    private final Method method;

    MethodWriter(ClassInfo classInfo, MethodInfo methodInfo) {
        this.setterMethodInfo = methodInfo;
        this.parameterType = ClassUtils.getType(this.setterMethodInfo.getDescriptor());
        this.method = classInfo.getMethod(this.setterMethodInfo, this.parameterType);
    }

    private static void write(Method method, Object instance, Object value) {
        try {
            method.invoke(instance, value);
        }
        catch (IllegalArgumentException iae) {
            throw new EntityAccessException("Failed to invoke method '" + method.getName() + "'. Expected argument type: " + method.getParameterTypes()[0] + " actual argument type: " + value.getClass(), iae);
        }
        catch (Exception e) {
            throw new EntityAccessException("Failed to invoke method '" + method.getName() + "'", e);
        }
    }

    public static Object read(Method method, Object instance) {
        try {
            return method.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(Object instance, Object value) {
        if (this.setterMethodInfo.hasConverter()) {
            value = this.setterMethodInfo.converter().toEntityAttribute(value);
        }
        if (this.setterMethodInfo.isScalar()) {
            String descriptor = this.setterMethodInfo.getTypeParameterDescriptor() == null ? this.setterMethodInfo.getDescriptor() : this.setterMethodInfo.getTypeParameterDescriptor();
            value = Utils.coerceTypes(ClassUtils.getType(descriptor), value);
        }
        MethodWriter.write(this.method, instance, value);
    }

    @Override
    public Class<?> type() {
        if (this.setterMethodInfo.hasConverter()) {
            try {
                for (Method method : this.setterMethodInfo.converter().getClass().getDeclaredMethods()) {
                    if (!method.getName().equals("toGraphProperty") || method.isSynthetic()) continue;
                    return method.getReturnType();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.parameterType;
    }

    @Override
    public String relationshipName() {
        return this.setterMethodInfo.relationship();
    }

    @Override
    public String relationshipDirection() {
        return this.setterMethodInfo.relationshipDirection("UNDIRECTED");
    }

    @Override
    public boolean forScalar() {
        if (Iterable.class.isAssignableFrom(this.type())) {
            return false;
        }
        return !this.type().isArray();
    }

    @Override
    public String typeParameterDescriptor() {
        return this.setterMethodInfo.getTypeDescriptor();
    }
}

