/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.entityaccess;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.metadata.BaseClassNotFoundException;
import org.neo4j.ogm.metadata.MappingException;
import org.neo4j.ogm.metadata.MetaData;
import org.neo4j.ogm.metadata.classloader.MetaDataClassLoader;
import org.neo4j.ogm.metadata.info.ClassInfo;
import org.neo4j.ogm.model.NodeModel;
import org.neo4j.ogm.model.RelationshipModel;

public class EntityFactory {
    private final Map<String, String> taxaLeafClass = new HashMap<String, String>();
    private final MetaData metadata;

    public EntityFactory(MetaData metadata) {
        this.metadata = metadata;
    }

    public <T> T newObject(NodeModel nodeModel) {
        return this.instantiateObjectFromTaxa(nodeModel.getLabels());
    }

    public <T> T newObject(RelationshipModel edgeModel) {
        return this.instantiateObjectFromTaxa(edgeModel.getType());
    }

    public <T> T newObject(ClassInfo classInfo) {
        return EntityFactory.instantiate(classInfo.getUnderlyingClass());
    }

    public <T> T newObject(Class<T> clarse) {
        return EntityFactory.instantiate(clarse);
    }

    private <T> T instantiateObjectFromTaxa(String ... taxa) {
        if (taxa == null || taxa.length == 0) {
            throw new BaseClassNotFoundException("<null>");
        }
        String fqn = this.resolve(taxa);
        try {
            Class loadedClass = MetaDataClassLoader.loadClass(fqn);
            return EntityFactory.instantiate(loadedClass);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("Unable to load class with FQN: " + fqn, e);
        }
    }

    private String resolve(String ... taxa) {
        String fqn = this.taxaLeafClass.get(Arrays.toString(taxa));
        if (fqn == null) {
            ClassInfo classInfo = this.metadata.resolve(taxa);
            if (classInfo != null) {
                fqn = classInfo.name();
                this.taxaLeafClass.put(Arrays.toString(taxa), fqn);
            } else {
                throw new BaseClassNotFoundException(Arrays.toString(taxa));
            }
        }
        return fqn;
    }

    private static <T> T instantiate(Class<T> loadedClass) {
        try {
            Constructor<T> defaultConstructor = loadedClass.getDeclaredConstructor(new Class[0]);
            defaultConstructor.setAccessible(true);
            return defaultConstructor.newInstance(new Object[0]);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            throw new MappingException("Unable to instantiate " + loadedClass, e);
        }
    }
}

