/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.statement;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.Filters;
import org.neo4j.ogm.cypher.query.Pagination;
import org.neo4j.ogm.cypher.query.SortOrder;

public class ParameterisedStatement {
    private String statement;
    private int withIndex;
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String[] resultDataContents;
    private boolean includeStats = false;
    private Pagination paging;
    private SortOrder sortOrder = new SortOrder();
    private Filters filters = new Filters();

    public ParameterisedStatement(String cypher, Map<String, ?> parameters) {
        this(cypher, parameters, "row");
    }

    protected ParameterisedStatement(String cypher, Map<String, ?> parameters, String ... resultDataContents) {
        this.statement = cypher;
        this.parameters.putAll(parameters);
        this.resultDataContents = resultDataContents;
        this.parseStatement();
    }

    protected ParameterisedStatement(String cypher, Map<String, ?> parameters, boolean includeStats, String ... resultDataContents) {
        this.statement = cypher;
        this.parameters.putAll(parameters);
        this.resultDataContents = resultDataContents;
        this.includeStats = includeStats;
    }

    public String getStatement() {
        String pagination;
        String stmt = this.statement.trim();
        String sorting = this.sortOrder().toString();
        String string = pagination = this.paging == null ? "" : this.page().toString();
        if (sorting.length() > 0 || pagination.length() > 0) {
            if (this.withIndex > -1) {
                String withClause;
                int nextClauseIndex = stmt.indexOf(" MATCH", this.withIndex);
                String newWithClause = withClause = stmt.substring(this.withIndex, nextClauseIndex);
                if (stmt.contains(")-[r")) {
                    sorting = sorting.replace("$", "r");
                    if (!withClause.contains(",r")) {
                        newWithClause = newWithClause + ",r";
                    }
                } else {
                    sorting = sorting.replace("$", "n");
                }
                stmt = stmt.replace(withClause, newWithClause + sorting + pagination);
            } else if (stmt.startsWith("MATCH p=(")) {
                String withClause = "WITH p";
                if (stmt.contains(")-[r")) {
                    withClause = withClause + ",r";
                    sorting = sorting.replace("$", "r");
                } else {
                    sorting = sorting.replace("$", "n");
                }
                stmt = stmt.replace("RETURN ", withClause + sorting + pagination + " RETURN ");
            } else {
                sorting = sorting.replace("$", "n");
                stmt = stmt.replace("RETURN ", "WITH n" + sorting + pagination + " RETURN ");
            }
        }
        return stmt;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public String[] getResultDataContents() {
        return this.resultDataContents;
    }

    public boolean isIncludeStats() {
        return this.includeStats;
    }

    public Pagination page() {
        return this.paging;
    }

    public SortOrder sortOrder() {
        return this.sortOrder;
    }

    protected void addPaging(Pagination page) {
        this.paging = page;
    }

    public void addSortOrder(SortOrder sortOrder) {
        this.sortOrder = sortOrder;
    }

    public void addFilters(Filters filters) {
        this.filters = filters;
    }

    private void parseStatement() {
        this.withIndex = this.statement.indexOf("WITH n");
    }
}

