/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.neo4j.ogm.cypher.compiler.CypherCompiler;
import org.neo4j.ogm.cypher.compiler.CypherContext;
import org.neo4j.ogm.cypher.compiler.CypherEmitter;
import org.neo4j.ogm.cypher.compiler.DeletedRelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.ExistingNodeBuilder;
import org.neo4j.ogm.cypher.compiler.ExistingRelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.IdentifierManager;
import org.neo4j.ogm.cypher.compiler.NewBiDirectionalRelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.NewNodeBuilder;
import org.neo4j.ogm.cypher.compiler.NewRelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;
import org.neo4j.ogm.cypher.compiler.ReturnClauseBuilder;
import org.neo4j.ogm.cypher.statement.ParameterisedStatement;

public class SingleStatementCypherCompiler
implements CypherCompiler {
    private final IdentifierManager identifiers = new IdentifierManager();
    private final Set<CypherEmitter> newNodes = new TreeSet<CypherEmitter>();
    private final Set<CypherEmitter> updatedNodes = new TreeSet<CypherEmitter>();
    private final Set<CypherEmitter> newRelationships = new TreeSet<CypherEmitter>();
    private final Set<CypherEmitter> updatedRelationships = new TreeSet<CypherEmitter>();
    private final Set<CypherEmitter> deletedRelationships = new TreeSet<CypherEmitter>();
    private final CypherEmitter returnClause = new ReturnClauseBuilder();
    private final CypherContext context = new CypherContext();

    @Override
    @Deprecated
    public void relate(String startNode, String relationshipType, Map<String, Object> relationshipProperties, String endNode) {
        RelationshipBuilder newRelationship = this.newRelationship();
        newRelationship.type(relationshipType);
        for (Map.Entry<String, Object> property : relationshipProperties.entrySet()) {
            newRelationship.addProperty(property.getKey(), property.getValue());
        }
        newRelationship.relate(startNode, endNode);
        this.newRelationships.add(newRelationship);
    }

    @Override
    public void unrelate(String startNode, String relationshipType, String endNode, Long relId) {
        this.deletedRelationships.add(new DeletedRelationshipBuilder(relationshipType, startNode, endNode, this.identifiers.nextIdentifier(), relId));
    }

    @Override
    public NodeBuilder newNode() {
        NewNodeBuilder newNode = new NewNodeBuilder(this.identifiers.nextIdentifier());
        this.newNodes.add(newNode);
        return newNode;
    }

    @Override
    public NodeBuilder existingNode(Long existingNodeId) {
        ExistingNodeBuilder node = new ExistingNodeBuilder(this.identifiers.identifier(existingNodeId));
        this.updatedNodes.add(node);
        return node;
    }

    @Override
    public RelationshipBuilder newRelationship() {
        NewRelationshipBuilder builder = new NewRelationshipBuilder(this.identifiers.nextIdentifier());
        this.newRelationships.add(builder);
        return builder;
    }

    @Override
    public RelationshipBuilder newBiDirectionalRelationship() {
        NewBiDirectionalRelationshipBuilder builder = new NewBiDirectionalRelationshipBuilder(this.identifiers.nextIdentifier(), this.identifiers.nextIdentifier());
        this.newRelationships.add(builder);
        return builder;
    }

    @Override
    public RelationshipBuilder existingRelationship(Long existingRelationshipId) {
        ExistingRelationshipBuilder builder = new ExistingRelationshipBuilder(this.identifiers.nextIdentifier(), existingRelationshipId);
        this.updatedRelationships.add(builder);
        return builder;
    }

    @Override
    public List<ParameterisedStatement> getStatements() {
        StringBuilder queryBuilder = new StringBuilder();
        TreeSet<String> varStack = new TreeSet<String>();
        TreeSet<String> newStack = new TreeSet<String>();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (!this.newNodes.isEmpty()) {
            queryBuilder.append(" CREATE ");
            Iterator<CypherEmitter> it = this.newNodes.iterator();
            while (it.hasNext()) {
                NodeBuilder nodeBuilder = (NodeBuilder)it.next();
                if (!nodeBuilder.emit(queryBuilder, parameters, varStack)) continue;
                newStack.add(nodeBuilder.reference());
                if (!it.hasNext()) continue;
                queryBuilder.append(", ");
            }
        }
        for (CypherEmitter cypherEmitter : this.updatedNodes) {
            cypherEmitter.emit(queryBuilder, parameters, varStack);
        }
        for (RelationshipBuilder relationshipBuilder : this.newRelationships) {
            if (!relationshipBuilder.emit(queryBuilder, parameters, varStack)) continue;
            newStack.add(relationshipBuilder.reference);
        }
        for (CypherEmitter cypherEmitter : this.updatedRelationships) {
            cypherEmitter.emit(queryBuilder, parameters, varStack);
        }
        for (CypherEmitter cypherEmitter : this.deletedRelationships) {
            cypherEmitter.emit(queryBuilder, parameters, varStack);
        }
        this.returnClause.emit(queryBuilder, parameters, newStack);
        return Collections.singletonList(new ParameterisedStatement(queryBuilder.toString(), parameters));
    }

    @Override
    public CypherContext context() {
        return this.context;
    }

    @Override
    public CypherContext compile() {
        this.context.setStatements(this.getStatements());
        return this.context;
    }

    @Override
    public void release(RelationshipBuilder relationshipBuilder) {
        this.identifiers.releaseIdentifier();
    }

    @Override
    public String nextIdentifier() {
        return this.identifiers.nextIdentifier();
    }
}

