/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.ogm.cypher.compiler.CypherEmitter;

public abstract class RelationshipBuilder
implements CypherEmitter,
Comparable<RelationshipBuilder> {
    protected Long id;
    protected String type;
    protected String startNodeIdentifier;
    protected String endNodeIdentifier;
    protected String reference;
    private Boolean singleton = true;
    private String direction;
    final Map<String, Object> props = new HashMap<String, Object>();

    public Boolean isSingleton() {
        return this.singleton;
    }

    public void setSingleton(Boolean singleton) {
        this.singleton = singleton;
    }

    protected RelationshipBuilder(String variableName) {
        this.reference = variableName;
    }

    public String getType() {
        return this.type;
    }

    public RelationshipBuilder type(String type) {
        this.type = type;
        return this;
    }

    public void addProperty(String propertyName, Object propertyValue) {
        this.props.put(propertyName, propertyValue);
    }

    public RelationshipBuilder direction(String direction) {
        this.direction = direction;
        return this;
    }

    public boolean hasDirection(String direction) {
        return this.direction != null && this.direction.equals(direction);
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public abstract void relate(String var1, String var2);

    public abstract boolean isNew();

    public String getReference() {
        return this.reference;
    }

    @Override
    public int compareTo(RelationshipBuilder o) {
        return this.reference.compareTo(o.reference);
    }

    public String toString() {
        return "(" + this.startNodeIdentifier + ")-[" + this.reference + ":`" + this.type + "`]->(" + this.endNodeIdentifier + ")";
    }
}

