/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.neo4j.ogm.cypher.compiler.CypherEmitter;
import org.neo4j.ogm.entityaccess.EntityAccessStrategy;
import org.neo4j.ogm.metadata.info.ClassInfo;

public abstract class NodeBuilder
implements CypherEmitter,
Comparable<NodeBuilder> {
    private final String cypherReference;
    final Map<String, Object> props = new HashMap<String, Object>();
    final List<String> labels = new ArrayList<String>();

    NodeBuilder(String variableName) {
        this.cypherReference = variableName;
    }

    NodeBuilder addLabel(String labelName) {
        this.labels.add(labelName);
        return this;
    }

    NodeBuilder addProperty(String propertyName, Object value) {
        this.props.put(propertyName, value);
        return this;
    }

    public NodeBuilder addLabels(Iterable<String> labelName) {
        for (String label : labelName) {
            this.addLabel(label);
        }
        return this;
    }

    public abstract NodeBuilder mapProperties(Object var1, ClassInfo var2, EntityAccessStrategy var3);

    public String toString() {
        return "(" + this.cypherReference + ":" + this.labels + " " + this.props + ")";
    }

    public static String toCsv(Iterable<String> elements) {
        StringBuilder sb = new StringBuilder();
        for (String element : elements) {
            sb.append(element).append(',');
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public String reference() {
        return this.cypherReference;
    }

    @Override
    public int compareTo(NodeBuilder o) {
        return this.cypherReference.compareTo(o.cypherReference);
    }
}

