/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;

class NewRelationshipBuilder
extends RelationshipBuilder {
    public NewRelationshipBuilder(String reference) {
        super(reference);
    }

    @Override
    public void relate(String startNodeIdentifier, String endNodeIdentifier) {
        this.startNodeIdentifier = startNodeIdentifier;
        this.endNodeIdentifier = endNodeIdentifier;
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public boolean emit(StringBuilder queryBuilder, Map<String, Object> parameters, Set<String> varStack) {
        if (this.startNodeIdentifier == null || this.endNodeIdentifier == null) {
            return false;
        }
        if (!varStack.isEmpty()) {
            queryBuilder.append(" WITH ").append(NodeBuilder.toCsv(varStack));
        }
        if (!varStack.contains(this.startNodeIdentifier)) {
            queryBuilder.append(" MATCH (");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append(") WHERE id(");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append(")={");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append("}");
            parameters.put(this.startNodeIdentifier, Long.parseLong(this.startNodeIdentifier.substring(1)));
            varStack.add(this.startNodeIdentifier);
        }
        if (!varStack.contains(this.endNodeIdentifier)) {
            queryBuilder.append(" MATCH (");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append(") WHERE id(");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append(")={");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append("}");
            parameters.put(this.endNodeIdentifier, Long.parseLong(this.endNodeIdentifier.substring(1)));
            varStack.add(this.endNodeIdentifier);
        }
        queryBuilder.append(" MERGE (");
        queryBuilder.append(this.startNodeIdentifier);
        queryBuilder.append(")-[").append(this.reference).append(":`");
        queryBuilder.append(this.type);
        queryBuilder.append('`');
        if (!this.props.isEmpty()) {
            queryBuilder.append('{');
            String propertyVariablePrefix = '{' + this.reference + "_props}.";
            boolean firstProperty = true;
            for (Map.Entry relationshipProperty : this.props.entrySet()) {
                if (relationshipProperty.getValue() == null) continue;
                if (!firstProperty) {
                    queryBuilder.append(',');
                }
                queryBuilder.append((String)relationshipProperty.getKey()).append(':').append(propertyVariablePrefix).append((String)relationshipProperty.getKey());
                firstProperty = false;
            }
            if (firstProperty) {
                queryBuilder.setLength(queryBuilder.length() - 1);
            } else {
                queryBuilder.append('}');
            }
            parameters.put(this.reference + "_props", this.props);
        }
        queryBuilder.append("]->(");
        queryBuilder.append(this.endNodeIdentifier);
        queryBuilder.append(")");
        varStack.add(this.reference);
        return true;
    }
}

