/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;

public class NewBiDirectionalRelationshipBuilder
extends RelationshipBuilder {
    String otherReference;

    public NewBiDirectionalRelationshipBuilder(String reference1, String otherReference) {
        super(reference1);
        this.otherReference = otherReference;
    }

    @Override
    public void relate(String startNodeIdentifier, String endNodeIdentifier) {
        this.startNodeIdentifier = startNodeIdentifier;
        this.endNodeIdentifier = endNodeIdentifier;
    }

    @Override
    public boolean isNew() {
        return true;
    }

    @Override
    public boolean emit(StringBuilder queryBuilder, Map<String, Object> parameters, Set<String> varStack) {
        String propertyVariablePrefix;
        if (this.startNodeIdentifier == null || this.endNodeIdentifier == null) {
            return false;
        }
        if (!varStack.isEmpty()) {
            queryBuilder.append(" WITH ").append(NodeBuilder.toCsv(varStack));
        }
        if (!varStack.contains(this.startNodeIdentifier)) {
            queryBuilder.append(" MATCH (");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append(") WHERE id(");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append(")={");
            queryBuilder.append(this.startNodeIdentifier);
            queryBuilder.append("}");
            parameters.put(this.startNodeIdentifier, Long.parseLong(this.startNodeIdentifier.substring(1)));
            varStack.add(this.startNodeIdentifier);
        }
        if (!varStack.contains(this.endNodeIdentifier)) {
            queryBuilder.append(" MATCH (");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append(") WHERE id(");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append(")={");
            queryBuilder.append(this.endNodeIdentifier);
            queryBuilder.append("}");
            parameters.put(this.endNodeIdentifier, Long.parseLong(this.endNodeIdentifier.substring(1)));
            varStack.add(this.endNodeIdentifier);
        }
        queryBuilder.append(" MERGE (");
        queryBuilder.append(this.startNodeIdentifier);
        queryBuilder.append(")-[").append(this.reference).append(":`");
        queryBuilder.append(this.type);
        queryBuilder.append('`');
        if (!this.props.isEmpty()) {
            queryBuilder.append('{');
            propertyVariablePrefix = '{' + this.reference + "_props}.";
            for (Map.Entry relationshipProperty : this.props.entrySet()) {
                if (relationshipProperty.getValue() == null) continue;
                queryBuilder.append((String)relationshipProperty.getKey()).append(':').append(propertyVariablePrefix).append((String)relationshipProperty.getKey()).append(',');
            }
            queryBuilder.setLength(queryBuilder.length() - 1);
            queryBuilder.append('}');
            parameters.put(this.reference + "_props", this.props);
        }
        queryBuilder.append("]->(");
        queryBuilder.append(this.endNodeIdentifier);
        queryBuilder.append(")");
        queryBuilder.append(" MERGE (");
        queryBuilder.append(this.endNodeIdentifier);
        queryBuilder.append(")-[").append(this.otherReference).append(":`");
        queryBuilder.append(this.type);
        queryBuilder.append('`');
        if (!this.props.isEmpty()) {
            queryBuilder.append('{');
            propertyVariablePrefix = '{' + this.otherReference + "_props}.";
            for (Map.Entry relationshipProperty : this.props.entrySet()) {
                if (relationshipProperty.getValue() == null) continue;
                queryBuilder.append((String)relationshipProperty.getKey()).append(':').append(propertyVariablePrefix).append((String)relationshipProperty.getKey()).append(',');
            }
            queryBuilder.setLength(queryBuilder.length() - 1);
            queryBuilder.append('}');
            parameters.put(this.otherReference + "_props", this.props);
        }
        queryBuilder.append("]->(");
        queryBuilder.append(this.startNodeIdentifier);
        queryBuilder.append(")");
        varStack.add(this.reference);
        return true;
    }
}

