/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.compiler.RelationshipBuilder;

class ExistingRelationshipBuilder
extends RelationshipBuilder {
    ExistingRelationshipBuilder(String variableName, Long relationshipId) {
        super(variableName);
        this.setId(relationshipId);
    }

    @Override
    public void relate(String startNodeIdentifier, String endNodeIdentifier) {
        this.startNodeIdentifier = startNodeIdentifier;
        this.endNodeIdentifier = endNodeIdentifier;
    }

    @Override
    public boolean isNew() {
        return false;
    }

    @Override
    public boolean emit(StringBuilder queryBuilder, Map<String, Object> parameters, Set<String> varStack) {
        if (this.startNodeIdentifier == null || this.endNodeIdentifier == null) {
            return false;
        }
        if (!varStack.isEmpty()) {
            queryBuilder.append(" WITH ").append(NodeBuilder.toCsv(varStack));
        }
        queryBuilder.append(" MATCH ()-[").append(this.reference).append("]->() WHERE id(").append(this.reference).append(")={").append(this.reference).append("}");
        parameters.put(this.reference, this.getId());
        if (!this.props.isEmpty()) {
            queryBuilder.append(" SET ").append(this.reference).append("+={").append(this.reference).append("_props} ");
            parameters.put(this.reference + "_props", this.props);
            varStack.add(this.reference);
        }
        return true;
    }
}

