/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.CypherEmitter;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;

public class DeletedRelationshipBuilder
implements CypherEmitter,
Comparable<DeletedRelationshipBuilder> {
    private final String type;
    private final String src;
    private final String tgt;
    private final String rid;
    private final Long relId;

    public DeletedRelationshipBuilder(String type, String src, String tgt, String rid, Long relId) {
        this.type = type;
        this.src = src;
        this.tgt = tgt;
        this.rid = rid;
        this.relId = relId;
    }

    @Override
    public boolean emit(StringBuilder queryBuilder, Map<String, Object> parameters, Set<String> varStack) {
        if (!varStack.isEmpty()) {
            queryBuilder.append(" WITH ").append(NodeBuilder.toCsv(varStack));
        }
        queryBuilder.append(" MATCH (");
        queryBuilder.append(this.src);
        queryBuilder.append(")-[");
        queryBuilder.append(this.rid);
        queryBuilder.append(":`");
        queryBuilder.append(this.type);
        queryBuilder.append("`]->(");
        queryBuilder.append(this.tgt);
        queryBuilder.append(")");
        boolean where = false;
        if (!varStack.contains(this.src)) {
            queryBuilder.append(" WHERE id(");
            queryBuilder.append(this.src);
            queryBuilder.append(")={");
            queryBuilder.append(this.src);
            queryBuilder.append("}");
            parameters.put(this.src, Long.parseLong(this.src.substring(1)));
            varStack.add(this.src);
            where = true;
        }
        if (!varStack.contains(this.tgt)) {
            if (where) {
                queryBuilder.append(" AND id(");
            } else {
                queryBuilder.append(" WHERE id(");
            }
            queryBuilder.append(this.tgt);
            queryBuilder.append(")={");
            queryBuilder.append(this.tgt);
            queryBuilder.append("}");
            varStack.add(this.tgt);
            parameters.put(this.tgt, Long.parseLong(this.tgt.substring(1)));
            where = true;
        }
        if (!varStack.contains(this.rid) && this.relId != null) {
            if (where) {
                queryBuilder.append(" AND id(");
            } else {
                queryBuilder.append(" WHERE id(");
            }
            queryBuilder.append(this.rid);
            queryBuilder.append(")={");
            queryBuilder.append(this.rid);
            queryBuilder.append("}");
            parameters.put(this.rid, this.relId);
            varStack.add(this.rid);
        }
        queryBuilder.append(" DELETE ");
        queryBuilder.append(this.rid);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeletedRelationshipBuilder that = (DeletedRelationshipBuilder)o;
        if (!this.rid.equals(that.rid)) {
            return false;
        }
        if (!this.src.equals(that.src)) {
            return false;
        }
        if (!this.tgt.equals(that.tgt)) {
            return false;
        }
        return this.type.equals(that.type);
    }

    public int hashCode() {
        int result = this.type.hashCode();
        result = 31 * result + this.src.hashCode();
        result = 31 * result + this.tgt.hashCode();
        result = 31 * result + this.rid.hashCode();
        return result;
    }

    @Override
    public int compareTo(DeletedRelationshipBuilder o) {
        return this.hashCode() - o.hashCode();
    }
}

