/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.cypher.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.neo4j.ogm.cypher.compiler.NodeBuilder;
import org.neo4j.ogm.cypher.statement.ParameterisedStatement;
import org.neo4j.ogm.mapper.MappedRelationship;

public class CypherContext {
    private final Map<Object, NodeBuilder> visitedObjects = new HashMap<Object, NodeBuilder>();
    private final Set<Object> visitedRelationshipEntities = new HashSet<Object>();
    private final Map<String, Object> createdObjects = new HashMap<String, Object>();
    private final Collection<MappedRelationship> registeredRelationships = new HashSet<MappedRelationship>();
    private final Collection<MappedRelationship> deletedRelationships = new HashSet<MappedRelationship>();
    private final Collection<Object> log = new HashSet<Object>();
    private List<ParameterisedStatement> statements;

    public boolean visited(Object obj) {
        return this.visitedObjects.containsKey(obj);
    }

    public void visit(Object toPersist, NodeBuilder nodeBuilder) {
        this.visitedObjects.put(toPersist, nodeBuilder);
    }

    public void registerRelationship(MappedRelationship mappedRelationship) {
        this.registeredRelationships.add(mappedRelationship);
    }

    public boolean removeRegisteredRelationship(MappedRelationship mappedRelationship) {
        return this.registeredRelationships.remove(mappedRelationship);
    }

    public NodeBuilder nodeBuilder(Object obj) {
        return this.visitedObjects.get(obj);
    }

    public boolean isRegisteredRelationship(MappedRelationship mappedRelationship) {
        return this.registeredRelationships.contains(mappedRelationship);
    }

    public void setStatements(List<ParameterisedStatement> statements) {
        this.statements = statements;
    }

    public List<ParameterisedStatement> getStatements() {
        return this.statements;
    }

    public void registerNewObject(String cypherName, Object toPersist) {
        this.createdObjects.put(cypherName, toPersist);
    }

    public Object getNewObject(String cypherName) {
        return this.createdObjects.get(cypherName);
    }

    public Collection<MappedRelationship> registeredRelationships() {
        return this.registeredRelationships;
    }

    public void log(Object object) {
        this.log.add(object);
    }

    public Collection<Object> log() {
        return this.log;
    }

    public boolean deregisterOutgoingRelationships(Long src, String relationshipType, Class endNodeType) {
        MappedRelationship mappedRelationship;
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        boolean nothingToDelete = true;
        ArrayList<MappedRelationship> cleared = new ArrayList<MappedRelationship>();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getStartNodeId() != src.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(mappedRelationship.getEndNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (this.isMappedRelationshipAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    public boolean deregisterIncomingRelationships(Long tgt, String relationshipType, Class endNodeType, boolean relationshipEntity) {
        MappedRelationship mappedRelationship;
        Iterator<MappedRelationship> iterator = this.registeredRelationships.iterator();
        ArrayList<MappedRelationship> cleared = new ArrayList<MappedRelationship>();
        boolean nothingToDelete = true;
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (mappedRelationship.getEndNodeId() != tgt.longValue() || !mappedRelationship.getRelationshipType().equals(relationshipType) || !endNodeType.equals(relationshipEntity ? mappedRelationship.getEndNodeType() : mappedRelationship.getStartNodeType())) continue;
            cleared.add(mappedRelationship);
            iterator.remove();
            nothingToDelete = false;
        }
        if (nothingToDelete) {
            return true;
        }
        iterator = cleared.iterator();
        while (iterator.hasNext()) {
            mappedRelationship = iterator.next();
            if (this.isMappedRelationshipAlreadyDeleted(mappedRelationship)) {
                this.registerRelationship(mappedRelationship);
                iterator.remove();
                continue;
            }
            this.deletedRelationships.add(mappedRelationship);
        }
        return cleared.size() > 0;
    }

    public void visitRelationshipEntity(Object relationshipEntity) {
        this.visitedRelationshipEntities.add(relationshipEntity);
    }

    public boolean visitedRelationshipEntity(Object relationshipEntity) {
        return this.visitedRelationshipEntities.contains(relationshipEntity);
    }

    private boolean isMappedRelationshipAlreadyDeleted(MappedRelationship mappedRelationship) {
        for (MappedRelationship deletedRelationship : this.deletedRelationships) {
            if (deletedRelationship.getEndNodeId() != mappedRelationship.getEndNodeId() || deletedRelationship.getStartNodeId() != mappedRelationship.getStartNodeId() || !deletedRelationship.getRelationshipType().equals(mappedRelationship.getRelationshipType())) continue;
            return true;
        }
        return false;
    }
}

