/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.ogm.authentication;

import org.neo4j.ogm.authentication.AuthTokenCredentials;
import org.neo4j.ogm.authentication.Neo4jCredentials;
import org.neo4j.ogm.authentication.UsernamePasswordCredentials;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CredentialsService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CredentialsService.class);

    public static Neo4jCredentials<?> userNameAndPassword() {
        String userName = System.getProperty("username");
        String password = System.getProperty("password");
        if (userName != null) {
            if (password != null) {
                LOGGER.debug("Using credentials supplied");
                return new UsernamePasswordCredentials(userName, password);
            }
            LOGGER.warn("Incomplete credentials supplied");
        } else {
            LOGGER.warn("No credentials supplied");
        }
        return null;
    }

    public static Neo4jCredentials<?> authToken() {
        String token = System.getProperty("neo4j.auth");
        if (token != null) {
            return new AuthTokenCredentials(token);
        }
        LOGGER.warn("No credentials supplied");
        return null;
    }
}

