/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene.explicit;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.KeepOnlyLastCommitDeletionPolicy;
import org.apache.lucene.index.SnapshotDeletionPolicy;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.similarities.Similarity;
import org.apache.lucene.store.Directory;
import org.neo4j.index.impl.lucene.explicit.IndexIdentifier;
import org.neo4j.index.impl.lucene.explicit.IndexReference;
import org.neo4j.index.impl.lucene.explicit.IndexReferenceFactory;
import org.neo4j.index.impl.lucene.explicit.IndexType;
import org.neo4j.index.impl.lucene.explicit.IndexTypeCache;
import org.neo4j.index.impl.lucene.explicit.LuceneDataSource;
import org.neo4j.index.impl.lucene.explicit.WritableIndexReference;
import org.neo4j.kernel.api.exceptions.explicitindex.ExplicitIndexNotFoundKernelException;

class WritableIndexReferenceFactory
extends IndexReferenceFactory {
    WritableIndexReferenceFactory(LuceneDataSource.LuceneFilesystemFacade filesystemFacade, File baseStorePath, IndexTypeCache typeCache) {
        super(filesystemFacade, baseStorePath, typeCache);
    }

    @Override
    IndexReference createIndexReference(IndexIdentifier identifier) throws IOException, ExplicitIndexNotFoundKernelException {
        IndexWriter writer = this.newIndexWriter(identifier);
        DirectoryReader reader = DirectoryReader.open((IndexWriter)writer, (boolean)true);
        IndexSearcher indexSearcher = this.newIndexSearcher(identifier, (IndexReader)reader);
        return new WritableIndexReference(identifier, indexSearcher, writer);
    }

    @Override
    IndexReference refresh(IndexReference indexReference) throws ExplicitIndexNotFoundKernelException {
        try {
            DirectoryReader reader = (DirectoryReader)indexReference.getSearcher().getIndexReader();
            IndexWriter writer = indexReference.getWriter();
            DirectoryReader reopened = DirectoryReader.openIfChanged((DirectoryReader)reader, (IndexWriter)writer);
            if (reopened != null) {
                IndexSearcher newSearcher = this.newIndexSearcher(indexReference.getIdentifier(), (IndexReader)reopened);
                indexReference.detachOrClose();
                return new WritableIndexReference(indexReference.getIdentifier(), newSearcher, writer);
            }
            return indexReference;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private IndexWriter newIndexWriter(IndexIdentifier identifier) throws ExplicitIndexNotFoundKernelException {
        try {
            Directory indexDirectory = this.getIndexDirectory(identifier);
            IndexType type = this.getType(identifier);
            IndexWriterConfig writerConfig = new IndexWriterConfig(type.analyzer);
            writerConfig.setIndexDeletionPolicy((IndexDeletionPolicy)new SnapshotDeletionPolicy((IndexDeletionPolicy)new KeepOnlyLastCommitDeletionPolicy()));
            Similarity similarity = type.getSimilarity();
            if (similarity != null) {
                writerConfig.setSimilarity(similarity);
            }
            return new IndexWriter(indexDirectory, writerConfig);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

