/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import org.apache.lucene.document.Document;
import org.neo4j.index.impl.lucene.AbstractIndexHits;
import org.neo4j.index.impl.lucene.Hits;

public class HitsIterator
extends AbstractIndexHits<Document> {
    private final int size;
    private final Hits hits;
    private int index;

    public HitsIterator(Hits hits) {
        this.size = hits.length();
        this.hits = hits;
    }

    protected Document fetchNextOrNull() {
        int i = this.index++;
        try {
            return i < this.size() ? this.hits.doc(i) : null;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public float currentScore() {
        int i = this.index - 1;
        try {
            return i >= 0 && i < this.size() ? this.hits.score(i) : -1.0f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int size() {
        return this.size;
    }
}

