/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermQuery;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.index.Index;
import org.neo4j.graphdb.index.IndexHits;
import org.neo4j.index.impl.lucene.AbstractIndexHits;
import org.neo4j.index.impl.lucene.CombinedIndexHits;
import org.neo4j.index.impl.lucene.ConstantScoreIterator;
import org.neo4j.index.impl.lucene.DocToIdIterator;
import org.neo4j.index.impl.lucene.Hits;
import org.neo4j.index.impl.lucene.HitsIterator;
import org.neo4j.index.impl.lucene.IdToEntityIterator;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.IndexSearcherRef;
import org.neo4j.index.impl.lucene.IndexType;
import org.neo4j.index.impl.lucene.LuceneCommand;
import org.neo4j.index.impl.lucene.LuceneIndexImplementation;
import org.neo4j.index.impl.lucene.LuceneTransaction;
import org.neo4j.index.impl.lucene.LuceneXaConnection;
import org.neo4j.index.impl.lucene.RelationshipId;
import org.neo4j.index.impl.lucene.TopDocsIterator;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.kernel.GraphDatabaseSPI;
import org.neo4j.kernel.impl.cache.LruCache;
import org.neo4j.kernel.impl.core.ReadOnlyDbException;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public abstract class LuceneIndex<T extends PropertyContainer>
implements Index<T> {
    static final String KEY_DOC_ID = "_id_";
    static final String KEY_START_NODE_ID = "_start_node_id_";
    static final String KEY_END_NODE_ID = "_end_node_id_";
    private static Set<String> FORBIDDEN_KEYS = new HashSet<String>(Arrays.asList(null, "_id_", "_start_node_id_", "_end_node_id_"));
    final LuceneIndexImplementation service;
    private final IndexIdentifier identifier;
    final IndexType type;
    private volatile boolean deleted;
    final Collection<Long> abandonedIds = new CopyOnWriteArraySet<Long>();

    LuceneIndex(LuceneIndexImplementation service, IndexIdentifier identifier) {
        this.service = service;
        this.identifier = identifier;
        this.type = service.dataSource().getType(identifier);
    }

    LuceneXaConnection getConnection() {
        this.assertNotDeleted();
        if (this.service.broker() == null) {
            throw new ReadOnlyDbException();
        }
        return (LuceneXaConnection)this.service.broker().acquireResourceConnection();
    }

    private void assertNotDeleted() {
        if (this.deleted) {
            throw new IllegalStateException("This index (" + this.identifier + ") has been deleted");
        }
    }

    public GraphDatabaseService getGraphDatabase() {
        return this.service.graphDb();
    }

    LuceneXaConnection getReadOnlyConnection() {
        this.assertNotDeleted();
        return this.service.broker() == null ? null : (LuceneXaConnection)this.service.broker().acquireReadOnlyResourceConnection();
    }

    void markAsDeleted() {
        this.deleted = true;
        this.abandonedIds.clear();
    }

    public String getName() {
        return this.identifier.indexName;
    }

    public void add(T entity, String key, Object value) {
        LuceneXaConnection connection = this.getConnection();
        this.assertValidKey(key);
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            connection.add(this, entity, key, oneValue);
        }
    }

    public T putIfAbsent(T entity, String key, Object value) {
        return (T)((GraphDatabaseSPI)this.service.graphDb()).getNodeManager().indexPutIfAbsent((Index)this, entity, key, value);
    }

    private void assertValidKey(String key) {
        if (FORBIDDEN_KEYS.contains(key)) {
            throw new IllegalArgumentException("Key " + key + " forbidden");
        }
    }

    public void remove(T entity, String key, Object value) {
        LuceneXaConnection connection = this.getConnection();
        this.assertValidKey(key);
        for (Object oneValue : IoPrimitiveUtils.asArray((Object)value)) {
            connection.remove(this, entity, key, oneValue);
        }
    }

    public void remove(T entity, String key) {
        LuceneXaConnection connection = this.getConnection();
        this.assertValidKey(key);
        connection.remove(this, entity, key);
    }

    public void remove(T entity) {
        LuceneXaConnection connection = this.getConnection();
        connection.remove(this, entity);
    }

    public void delete() {
        this.getConnection().deleteIndex(this);
    }

    public IndexHits<T> get(String key, Object value) {
        return this.query(this.type.get(key, value), key, value, null);
    }

    public IndexHits<T> query(String key, Object queryOrQueryObject) {
        QueryContext context = queryOrQueryObject instanceof QueryContext ? (QueryContext)queryOrQueryObject : null;
        return this.query(this.type.query(key, context != null ? context.getQueryOrQueryObject() : queryOrQueryObject, context), null, null, context);
    }

    public IndexHits<T> query(Object queryOrQueryObject) {
        return this.query(null, queryOrQueryObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IndexHits<T> query(Query query, String keyForDirectLookup, Object valueForDirectLookup, QueryContext additionalParametersOrNull) {
        ArrayList<Long> ids = new ArrayList<Long>();
        LuceneXaConnection con = this.getReadOnlyConnection();
        LuceneTransaction luceneTx = con != null ? con.getLuceneTx() : null;
        Set<Long> removedIds = Collections.emptySet();
        IndexSearcher additionsSearcher = null;
        if (luceneTx != null) {
            if (keyForDirectLookup != null) {
                ids.addAll(luceneTx.getAddedIds(this, keyForDirectLookup, valueForDirectLookup));
            } else {
                additionsSearcher = luceneTx.getAdditionsAsSearcher(this, additionalParametersOrNull);
            }
            removedIds = keyForDirectLookup != null ? luceneTx.getRemovedIds(this, keyForDirectLookup, valueForDirectLookup) : luceneTx.getRemovedIds(this, query);
        }
        this.service.dataSource().getReadLock();
        IndexHits idIterator = null;
        IndexSearcherRef searcher = null;
        try {
            searcher = this.service.dataSource().getIndexSearcher(this.identifier, true);
            if (searcher != null) {
                boolean foundInCache = false;
                LruCache<String, Collection<Long>> cachedIdsMap = null;
                if (keyForDirectLookup != null) {
                    cachedIdsMap = this.service.dataSource().getFromCache(this.identifier, keyForDirectLookup);
                    foundInCache = this.fillFromCache(cachedIdsMap, ids, keyForDirectLookup, valueForDirectLookup.toString(), removedIds);
                }
                if (!foundInCache) {
                    DocToIdIterator searchedIds = new DocToIdIterator(this.search(searcher, query, additionalParametersOrNull, additionsSearcher, removedIds), removedIds, searcher);
                    if (ids.isEmpty()) {
                        idIterator = searchedIds;
                    } else {
                        ArrayList iterators = new ArrayList();
                        iterators.add(searchedIds);
                        iterators.add(new ConstantScoreIterator<Long>(ids, Float.NaN));
                        idIterator = new CombinedIndexHits(iterators);
                    }
                }
            }
        }
        finally {
            this.service.dataSource().releaseReadLock();
        }
        idIterator = idIterator == null ? new ConstantScoreIterator<Long>(ids, 0.0f) : idIterator;
        return this.newEntityIterator(idIterator);
    }

    public boolean isWriteable() {
        return true;
    }

    private IndexHits<T> newEntityIterator(IndexHits<Long> idIterator) {
        return new IdToEntityIterator<T>(idIterator){

            protected T underlyingObjectToObject(Long id) {
                return LuceneIndex.this.getById(id);
            }

            protected void itemDodged(Long item) {
                LuceneIndex.this.abandonedIds.add(item);
            }
        };
    }

    private boolean fillFromCache(LruCache<String, Collection<Long>> cachedNodesMap, List<Long> ids, String key, String valueAsString, Collection<Long> deletedNodes) {
        Collection cachedNodes;
        boolean found = false;
        if (cachedNodesMap != null && (cachedNodes = (Collection)cachedNodesMap.get((Object)valueAsString)) != null) {
            found = true;
            for (Long cachedNodeId : cachedNodes) {
                if (deletedNodes.contains(cachedNodeId)) continue;
                ids.add(cachedNodeId);
            }
        }
        return found;
    }

    private IndexHits<Document> search(IndexSearcherRef searcherRef, Query query, QueryContext additionalParametersOrNull, IndexSearcher additionsSearcher, Collection<Long> removed) {
        try {
            if (additionsSearcher != null && !removed.isEmpty()) {
                this.letThroughAdditions(additionsSearcher, query, removed);
            }
            IndexSearcher searcher = additionsSearcher == null ? searcherRef.getSearcher() : new IndexSearcher((IndexReader)new MultiReader(new IndexReader[]{searcherRef.getSearcher().getIndexReader(), additionsSearcher.getIndexReader()}));
            AbstractIndexHits result = null;
            if (additionalParametersOrNull != null && additionalParametersOrNull.getTop() > 0) {
                result = new TopDocsIterator(query, additionalParametersOrNull, searcher);
            } else {
                Sort sorting = additionalParametersOrNull != null ? additionalParametersOrNull.getSorting() : null;
                boolean forceScore = additionalParametersOrNull == null || !additionalParametersOrNull.getTradeCorrectnessForSpeed();
                Hits hits = new Hits(searcher, query, null, sorting, forceScore);
                result = new HitsIterator(hits);
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query " + this + " with " + query, e);
        }
    }

    private void letThroughAdditions(IndexSearcher additionsSearcher, Query query, Collection<Long> removed) throws IOException {
        Hits hits = new Hits(additionsSearcher, query, null);
        HitsIterator iterator = new HitsIterator(hits);
        while (iterator.hasNext()) {
            String idString = ((Document)iterator.next()).getField(KEY_DOC_ID).stringValue();
            removed.remove(Long.valueOf(idString));
        }
    }

    public void setCacheCapacity(String key, int capacity) {
        this.service.dataSource().setCacheCapacity(this.identifier, key, capacity);
    }

    public Integer getCacheCapacity(String key) {
        return this.service.dataSource().getCacheCapacity(this.identifier, key);
    }

    protected abstract T getById(long var1);

    protected abstract long getEntityId(T var1);

    protected abstract LuceneCommand newAddCommand(PropertyContainer var1, String var2, Object var3);

    protected abstract LuceneCommand newRemoveCommand(PropertyContainer var1, String var2, Object var3);

    IndexIdentifier getIdentifier() {
        return this.identifier;
    }

    static class RelationshipIndex
    extends LuceneIndex<Relationship>
    implements org.neo4j.graphdb.index.RelationshipIndex {
        private GraphDatabaseService gdb;

        RelationshipIndex(LuceneIndexImplementation service, GraphDatabaseService gdb, IndexIdentifier identifier) {
            super(service, identifier);
            this.gdb = gdb;
        }

        @Override
        protected Relationship getById(long id) {
            return this.gdb.getRelationshipById(id);
        }

        @Override
        protected long getEntityId(Relationship entity) {
            return entity.getId();
        }

        public IndexHits<Relationship> get(String key, Object valueOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            BooleanQuery query = new BooleanQuery();
            if (key != null && valueOrNull != null) {
                query.add(this.type.get(key, valueOrNull), BooleanClause.Occur.MUST);
            }
            RelationshipIndex.addIfNotNull(query, startNodeOrNull, LuceneIndex.KEY_START_NODE_ID);
            RelationshipIndex.addIfNotNull(query, endNodeOrNull, LuceneIndex.KEY_END_NODE_ID);
            return this.query((Query)query, null, null, null);
        }

        public IndexHits<Relationship> query(String key, Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            QueryContext context = queryOrQueryObjectOrNull != null && queryOrQueryObjectOrNull instanceof QueryContext ? (QueryContext)queryOrQueryObjectOrNull : null;
            BooleanQuery query = new BooleanQuery();
            if (context != null && context.getQueryOrQueryObject() != null || context == null && queryOrQueryObjectOrNull != null) {
                query.add(this.type.query(key, context != null ? context.getQueryOrQueryObject() : queryOrQueryObjectOrNull, context), BooleanClause.Occur.MUST);
            }
            RelationshipIndex.addIfNotNull(query, startNodeOrNull, LuceneIndex.KEY_START_NODE_ID);
            RelationshipIndex.addIfNotNull(query, endNodeOrNull, LuceneIndex.KEY_END_NODE_ID);
            return this.query((Query)query, null, null, context);
        }

        private static void addIfNotNull(BooleanQuery query, Node nodeOrNull, String field) {
            if (nodeOrNull != null) {
                query.add((Query)new TermQuery(new Term(field, "" + nodeOrNull.getId())), BooleanClause.Occur.MUST);
            }
        }

        public IndexHits<Relationship> query(Object queryOrQueryObjectOrNull, Node startNodeOrNull, Node endNodeOrNull) {
            return this.query(null, queryOrQueryObjectOrNull, startNodeOrNull, endNodeOrNull);
        }

        @Override
        protected LuceneCommand newAddCommand(PropertyContainer entity, String key, Object value) {
            Relationship rel = (Relationship)entity;
            return new LuceneCommand.AddRelationshipCommand(this.getIdentifier(), 2, RelationshipId.of(rel), key, value);
        }

        @Override
        protected LuceneCommand newRemoveCommand(PropertyContainer entity, String key, Object value) {
            Relationship rel = (Relationship)entity;
            return new LuceneCommand.RemoveCommand(this.getIdentifier(), 2, RelationshipId.of(rel), key, value);
        }

        public Class<Relationship> getEntityType() {
            return Relationship.class;
        }
    }

    static class NodeIndex
    extends LuceneIndex<Node> {
        private GraphDatabaseService gdb;

        NodeIndex(LuceneIndexImplementation service, GraphDatabaseService gdb, IndexIdentifier identifier) {
            super(service, identifier);
            this.gdb = gdb;
        }

        @Override
        protected Node getById(long id) {
            return this.gdb.getNodeById(id);
        }

        @Override
        protected long getEntityId(Node entity) {
            return entity.getId();
        }

        @Override
        protected LuceneCommand newAddCommand(PropertyContainer entity, String key, Object value) {
            return new LuceneCommand.AddCommand(this.getIdentifier(), 1, ((Node)entity).getId(), key, value);
        }

        @Override
        protected LuceneCommand newRemoveCommand(PropertyContainer entity, String key, Object value) {
            return new LuceneCommand.RemoveCommand(this.getIdentifier(), 1, ((Node)entity).getId(), key, value);
        }

        public Class<Node> getEntityType() {
            return Node.class;
        }
    }
}

