/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.index.impl.lucene;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.Version;
import org.neo4j.index.impl.lucene.ExactTxData;
import org.neo4j.index.impl.lucene.IndexIdentifier;
import org.neo4j.index.impl.lucene.LuceneDataSource;
import org.neo4j.index.impl.lucene.LuceneIndex;
import org.neo4j.index.impl.lucene.LuceneUtil;
import org.neo4j.index.impl.lucene.TxData;
import org.neo4j.index.lucene.QueryContext;
import org.neo4j.index.lucene.ValueContext;

abstract class IndexType {
    private static final IndexType EXACT = new IndexType(LuceneDataSource.KEYWORD_ANALYZER, false){

        @Override
        public Query deletionQuery(long entityId, String key, Object value) {
            BooleanQuery q = new BooleanQuery();
            q.add(this.idTermQuery(entityId), BooleanClause.Occur.MUST);
            q.add((Query)new TermQuery(new Term(key, value.toString())), BooleanClause.Occur.MUST);
            return q;
        }

        @Override
        public Query get(String key, Object value) {
            return this.queryForGet(key, value);
        }

        @Override
        public void addToDocument(Document document, String key, Object value) {
            document.add(this.instantiateField(key, value, Field.Index.NOT_ANALYZED));
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            HashSet<String> values = null;
            if (value != null) {
                String stringValue = value.toString();
                values = new HashSet<String>(Arrays.asList(document.getValues(key)));
                if (!values.remove(stringValue)) {
                    return;
                }
            }
            document.removeFields(key);
            if (value != null) {
                for (String existingValue : values) {
                    this.addToDocument(document, key, existingValue);
                }
            }
        }

        public String toString() {
            return "EXACT";
        }
    };
    final Analyzer analyzer;
    private final boolean toLowerCase;

    private IndexType(Analyzer analyzer, boolean toLowerCase) {
        this.analyzer = analyzer;
        this.toLowerCase = toLowerCase;
    }

    static IndexType getIndexType(IndexIdentifier identifier, Map<String, String> config) {
        String type = config.get("type");
        IndexType result = null;
        Similarity similarity = IndexType.getCustomSimilarity(config);
        boolean toLowerCase = IndexType.parseBoolean(config.get("to_lower_case"), true);
        Analyzer customAnalyzer = IndexType.getCustomAnalyzer(config);
        if (type != null) {
            if (type.equals("exact")) {
                result = EXACT;
            } else if (type.equals("fulltext")) {
                Analyzer analyzer = customAnalyzer;
                if (analyzer == null) {
                    analyzer = toLowerCase ? LuceneDataSource.LOWER_CASE_WHITESPACE_ANALYZER : LuceneDataSource.WHITESPACE_ANALYZER;
                }
                result = new CustomType(analyzer, toLowerCase, similarity);
            }
        } else {
            if (customAnalyzer == null) {
                throw new IllegalArgumentException("No 'type' was given (which can point out built-in analyzers, such as 'exact' and 'fulltext') and no 'analyzer' was given either (which can point out a custom " + Analyzer.class.getName() + " to use)");
            }
            result = new CustomType(customAnalyzer, toLowerCase, similarity);
        }
        return result;
    }

    private static boolean parseBoolean(String string, boolean valueIfNull) {
        return string == null ? valueIfNull : Boolean.parseBoolean(string);
    }

    private static Similarity getCustomSimilarity(Map<String, String> config) {
        return IndexType.getByClassName(config, "similarity", Similarity.class);
    }

    private static Analyzer getCustomAnalyzer(Map<String, String> config) {
        return IndexType.getByClassName(config, "analyzer", Analyzer.class);
    }

    private static <T> T getByClassName(Map<String, String> config, String configKey, Class<T> cls) {
        String className = config.get(configKey);
        if (className != null) {
            try {
                return Class.forName(className).asSubclass(cls).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    abstract Query deletionQuery(long var1, String var3, Object var4);

    abstract Query get(String var1, Object var2);

    TxData newTxData(LuceneIndex index) {
        return new ExactTxData(index);
    }

    Query query(String keyOrNull, Object value, QueryContext contextOrNull) {
        if (value instanceof Query) {
            return (Query)value;
        }
        QueryParser parser = new QueryParser(Version.LUCENE_30, keyOrNull, this.analyzer);
        parser.setAllowLeadingWildcard(true);
        parser.setLowercaseExpandedTerms(this.toLowerCase);
        if (contextOrNull != null && contextOrNull.getDefaultOperator() != null) {
            parser.setDefaultOperator(contextOrNull.getDefaultOperator());
        }
        try {
            return parser.parse(value.toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    abstract void addToDocument(Document var1, String var2, Object var3);

    Fieldable instantiateField(String key, Object value, Field.Index analyzed) {
        Field field = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            NumericField numberField = new NumericField(key, Field.Store.YES, true);
            if (value instanceof Long) {
                numberField.setLongValue(number.longValue());
            } else if (value instanceof Float) {
                numberField.setFloatValue(number.floatValue());
            } else if (value instanceof Double) {
                numberField.setDoubleValue(number.doubleValue());
            } else {
                numberField.setIntValue(number.intValue());
            }
            field = numberField;
        } else {
            field = new Field(key, value.toString(), Field.Store.YES, analyzed);
        }
        return field;
    }

    final void removeFromDocument(Document document, String key, Object value) {
        if (key == null && value == null) {
            this.clearDocument(document);
        } else {
            this.removeFieldsFromDocument(document, key, value);
        }
    }

    abstract void removeFieldsFromDocument(Document var1, String var2, Object var3);

    private void clearDocument(Document document) {
        HashSet<String> names = new HashSet<String>();
        for (Fieldable field : document.getFields()) {
            names.add(field.name());
        }
        names.remove("_id_");
        for (String name : names) {
            document.removeFields(name);
        }
    }

    static Document newBaseDocument(long entityId) {
        Document doc = new Document();
        doc.add((Fieldable)new Field("_id_", "" + entityId, Field.Store.YES, Field.Index.NOT_ANALYZED));
        return doc;
    }

    Term idTerm(long entityId) {
        return new Term("_id_", "" + entityId);
    }

    Query idTermQuery(long entityId) {
        return new TermQuery(this.idTerm(entityId));
    }

    Similarity getSimilarity() {
        return null;
    }

    Query queryForGet(String key, Object value) {
        Object realValue;
        if (value instanceof ValueContext && (realValue = ((ValueContext)value).getValue()) instanceof Number) {
            Number number = (Number)realValue;
            return LuceneUtil.rangeQuery(key, number, number, true, true);
        }
        return new TermQuery(new Term(key, value.toString()));
    }

    private static class CustomType
    extends IndexType {
        private final Similarity similarity;

        CustomType(Analyzer analyzer, boolean toLowerCase, Similarity similarity) {
            super(analyzer, toLowerCase);
            this.similarity = similarity;
        }

        @Override
        Similarity getSimilarity() {
            return this.similarity;
        }

        @Override
        public Query deletionQuery(long entityId, String key, Object value) {
            BooleanQuery q = new BooleanQuery();
            q.add(this.idTermQuery(entityId), BooleanClause.Occur.MUST);
            q.add((Query)new TermQuery(new Term(this.exactKey(key), value.toString())), BooleanClause.Occur.MUST);
            return q;
        }

        @Override
        public Query get(String key, Object value) {
            return new TermQuery(new Term(this.exactKey(key), value.toString()));
        }

        private String exactKey(String key) {
            return key + "_e";
        }

        @Override
        public void addToDocument(Document document, String key, Object value) {
            document.add((Fieldable)new Field(this.exactKey(key), value.toString(), Field.Store.YES, Field.Index.NOT_ANALYZED));
            document.add(this.instantiateField(key, value, Field.Index.ANALYZED));
        }

        @Override
        void removeFieldsFromDocument(Document document, String key, Object value) {
            String exactKey = this.exactKey(key);
            HashSet<String> values = null;
            if (value != null) {
                String stringValue = value.toString();
                values = new HashSet<String>(Arrays.asList(document.getValues(exactKey)));
                if (!values.remove(stringValue)) {
                    return;
                }
            }
            document.removeFields(exactKey);
            document.removeFields(key);
            if (value != null) {
                for (String existingValue : values) {
                    this.addToDocument(document, key, existingValue);
                }
            }
        }

        public String toString() {
            return "FULLTEXT";
        }
    }
}

