/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.function.Consumer;
import org.neo4j.function.Function;
import org.neo4j.function.Supplier;
import org.neo4j.function.Suppliers;
import org.neo4j.logging.AbstractLog;
import org.neo4j.logging.AbstractPrintWriterLogger;
import org.neo4j.logging.Level;
import org.neo4j.logging.Log;
import org.neo4j.logging.Logger;
import org.neo4j.logging.NullLogger;

public class FormattedLog
extends AbstractLog {
    static final Supplier<Date> DEFAULT_CURRENT_DATE_SUPPLIER = new Supplier<Date>(){

        public Date get() {
            return new Date();
        }
    };
    static final Function<OutputStream, PrintWriter> OUTPUT_STREAM_CONVERTER = new Function<OutputStream, PrintWriter>(){

        public PrintWriter apply(OutputStream outputStream) {
            return new PrintWriter(new OutputStreamWriter(outputStream, UTF_8));
        }
    };
    static final TimeZone UTC = TimeZone.getTimeZone("UTC");
    static final Charset UTF_8 = Charset.forName("UTF-8");
    private final Supplier<Date> currentDateSupplier;
    private final Supplier<PrintWriter> writerSupplier;
    private final TimeZone timezone;
    private final Object lock;
    private final String category;
    private final AtomicReference<Level> levelRef;
    private final boolean autoFlush;
    private final Logger debugLogger;
    private final Logger infoLogger;
    private final Logger warnLogger;
    private final Logger errorLogger;

    public static Builder withUTCTimeZone() {
        return new Builder().withUTCTimeZone();
    }

    public static Builder withTimeZone(TimeZone timezone) {
        return new Builder().withTimeZone(timezone);
    }

    public static Builder usingLock(Object lock) {
        return new Builder().usingLock(lock);
    }

    public static Builder withCategory(String category) {
        return new Builder().withCategory(category);
    }

    public static Builder withLogLevel(Level level) {
        return new Builder().withLogLevel(level);
    }

    public static Builder withoutAutoFlush() {
        return new Builder().withoutAutoFlush();
    }

    public static FormattedLog toOutputStream(OutputStream out) {
        return new Builder().toOutputStream(out);
    }

    public static FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
        return new Builder().toOutputStream(outSupplier);
    }

    public static FormattedLog toWriter(Writer writer) {
        return new Builder().toWriter(writer);
    }

    public static FormattedLog toPrintWriter(PrintWriter writer) {
        return new Builder().toPrintWriter(writer);
    }

    public static FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
        return new Builder().toPrintWriter(writerSupplier);
    }

    protected FormattedLog(Supplier<Date> currentDateSupplier, Supplier<PrintWriter> writerSupplier, TimeZone timezone, Object maybeLock, String category, Level level, boolean autoFlush) {
        this.currentDateSupplier = currentDateSupplier;
        this.writerSupplier = writerSupplier;
        this.timezone = timezone;
        this.lock = maybeLock != null ? maybeLock : this;
        this.category = category;
        this.levelRef = new AtomicReference<Level>(level);
        this.autoFlush = autoFlush;
        String debugPrefix = category != null && !category.isEmpty() ? "DEBUG [" + category + "]" : "DEBUG";
        String infoPrefix = category != null && !category.isEmpty() ? "INFO  [" + category + "]" : "INFO ";
        String warnPrefix = category != null && !category.isEmpty() ? "WARN  [" + category + "]" : "WARN ";
        String errorPrefix = category != null && !category.isEmpty() ? "ERROR [" + category + "]" : "ERROR";
        this.debugLogger = new FormattedLogger(writerSupplier, debugPrefix);
        this.infoLogger = new FormattedLogger(writerSupplier, infoPrefix);
        this.warnLogger = new FormattedLogger(writerSupplier, warnPrefix);
        this.errorLogger = new FormattedLogger(writerSupplier, errorPrefix);
    }

    public Level getLevel() {
        return this.levelRef.get();
    }

    public Level setLevel(Level level) {
        return this.levelRef.getAndSet(level);
    }

    @Override
    public boolean isDebugEnabled() {
        return Level.DEBUG.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    public Logger debugLogger() {
        return this.isDebugEnabled() ? this.debugLogger : NullLogger.getInstance();
    }

    public boolean isInfoEnabled() {
        return Level.INFO.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    public Logger infoLogger() {
        return this.isInfoEnabled() ? this.infoLogger : NullLogger.getInstance();
    }

    public boolean isWarnEnabled() {
        return Level.WARN.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    public Logger warnLogger() {
        return this.isWarnEnabled() ? this.warnLogger : NullLogger.getInstance();
    }

    public boolean isErrorEnabled() {
        return Level.ERROR.compareTo((Enum)this.levelRef.get()) >= 0;
    }

    @Override
    public Logger errorLogger() {
        return this.isErrorEnabled() ? this.errorLogger : NullLogger.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bulk(Consumer<Log> consumer) {
        PrintWriter writer;
        Object object = this.lock;
        synchronized (object) {
            writer = (PrintWriter)this.writerSupplier.get();
            consumer.accept((Object)new FormattedLog(this.currentDateSupplier, (Supplier<PrintWriter>)Suppliers.singleton((Object)writer), this.timezone, this.lock, this.category, this.levelRef.get(), false));
        }
        if (this.autoFlush) {
            writer.flush();
        }
    }

    private class FormattedLogger
    extends AbstractPrintWriterLogger {
        private final String prefix;
        private final DateFormat format;

        public FormattedLogger(Supplier<PrintWriter> writerSupplier, String prefix) {
            super(writerSupplier, FormattedLog.this.lock, FormattedLog.this.autoFlush);
            this.prefix = prefix;
            this.format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
            this.format.setTimeZone(FormattedLog.this.timezone);
        }

        @Override
        protected void writeLog(PrintWriter out, String message) {
            this.lineStart(out);
            out.write(message);
            out.println();
        }

        @Override
        protected void writeLog(PrintWriter out, String message, Throwable throwable) {
            this.lineStart(out);
            out.write(message);
            if (throwable.getMessage() != null) {
                out.write(32);
                out.write(throwable.getMessage());
            }
            out.println();
            throwable.printStackTrace(out);
        }

        @Override
        protected Logger getBulkLogger(PrintWriter out, Object lock) {
            return new FormattedLogger((Supplier<PrintWriter>)Suppliers.singleton((Object)out), this.prefix);
        }

        private void lineStart(PrintWriter out) {
            out.write(this.time());
            out.write(32);
            out.write(this.prefix);
            out.write(32);
        }

        private String time() {
            return this.format.format((Date)FormattedLog.this.currentDateSupplier.get());
        }
    }

    public static class Builder {
        private TimeZone timezone = TimeZone.getDefault();
        private Object lock = this;
        private String category = null;
        private Level level = Level.INFO;
        private boolean autoFlush = true;

        private Builder() {
        }

        public Builder withUTCTimeZone() {
            return this.withTimeZone(UTC);
        }

        public Builder withTimeZone(TimeZone timezone) {
            this.timezone = timezone;
            return this;
        }

        public Builder usingLock(Object lock) {
            this.lock = lock;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withLogLevel(Level level) {
            this.level = level;
            return this;
        }

        public Builder withoutAutoFlush() {
            this.autoFlush = false;
            return this;
        }

        public FormattedLog toOutputStream(OutputStream out) {
            return this.toPrintWriter((Supplier<PrintWriter>)Suppliers.singleton((Object)OUTPUT_STREAM_CONVERTER.apply((Object)out)));
        }

        public FormattedLog toOutputStream(Supplier<OutputStream> outSupplier) {
            return this.toPrintWriter((Supplier<PrintWriter>)Suppliers.adapted(outSupplier, OUTPUT_STREAM_CONVERTER));
        }

        public FormattedLog toWriter(Writer writer) {
            return this.toPrintWriter(new PrintWriter(writer));
        }

        public FormattedLog toPrintWriter(PrintWriter writer) {
            return this.toPrintWriter((Supplier<PrintWriter>)Suppliers.singleton((Object)writer));
        }

        public FormattedLog toPrintWriter(Supplier<PrintWriter> writerSupplier) {
            return new FormattedLog(DEFAULT_CURRENT_DATE_SUPPLIER, writerSupplier, this.timezone, this.lock, this.category, this.level, this.autoFlush);
        }
    }
}

