/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.impl.AbstractNeo4jTestCase;
import org.neo4j.unsafe.batchinsert.BatchGraphDatabaseImpl;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterImpl;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.BatchRelationship;

public class TestBatchInsert {
    private static Map<String, Object> properties = new HashMap<String, Object>();
    private static RelationshipType[] relTypeArray = new RelationshipType[]{RelTypes.REL_TYPE1, RelTypes.REL_TYPE2, RelTypes.REL_TYPE3, RelTypes.REL_TYPE4, RelTypes.REL_TYPE5};

    private BatchInserter newBatchInserter() {
        return this.newBatchInserter(true);
    }

    private GraphDatabaseService newBatchGraphDatabase() {
        return this.newBatchGraphDatabase(true);
    }

    private BatchInserter newBatchInserter(boolean eraseOld) {
        String storePath = AbstractNeo4jTestCase.getStorePath("neo-batch");
        if (eraseOld) {
            AbstractNeo4jTestCase.deleteFileOrDirectory(new File(storePath));
        }
        return BatchInserters.inserter((String)storePath);
    }

    private GraphDatabaseService newBatchGraphDatabase(boolean eraseOld) {
        String storePath = AbstractNeo4jTestCase.getStorePath("neo-batch-db");
        if (eraseOld) {
            AbstractNeo4jTestCase.deleteFileOrDirectory(new File(storePath));
        }
        return BatchInserters.batchDatabase((String)storePath);
    }

    @Test
    public void testSimple() {
        BatchInserter graphDb = this.newBatchInserter();
        long node1 = graphDb.createNode(null);
        long node2 = graphDb.createNode(null);
        long rel1 = graphDb.createRelationship(node1, node2, (RelationshipType)RelTypes.BATCH_TEST, null);
        BatchRelationship rel = graphDb.getRelationshipById(rel1);
        Assert.assertEquals((long)rel.getStartNode(), (long)node1);
        Assert.assertEquals((long)rel.getEndNode(), (long)node2);
        Assert.assertEquals((Object)RelTypes.BATCH_TEST.name(), (Object)rel.getType().name());
        graphDb.shutdown();
    }

    @Test
    public void testPropertySetFromGraphDbIsPersisted() {
        GraphDatabaseService gds = this.newBatchGraphDatabase();
        Node from = gds.createNode();
        long fromId = from.getId();
        Node to = gds.createNode();
        long toId = to.getId();
        Relationship rel = from.createRelationshipTo(to, (RelationshipType)DynamicRelationshipType.withName((String)"PROP_TEST"));
        long relId = rel.getId();
        from.setProperty("1", (Object)"one");
        to.setProperty("2", (Object)"two");
        rel.setProperty("3", (Object)"three");
        gds.shutdown();
        GraphDatabaseService db = this.newBatchGraphDatabase(false);
        from = db.getNodeById(fromId);
        Assert.assertEquals((Object)"one", (Object)from.getProperty("1"));
        to = db.getNodeById(toId);
        Assert.assertEquals((Object)"two", (Object)to.getProperty("2"));
        rel = db.getRelationshipById(relId);
        Assert.assertEquals((Object)"three", (Object)rel.getProperty("3"));
        db.shutdown();
    }

    @Test
    public void testSetAndAddNodeProperties() {
        BatchInserter inserter = this.newBatchInserter();
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"one", "one", "two", "two", "three", "three"}));
        inserter.setNodeProperty(tehNode, "four", (Object)"four");
        inserter.setNodeProperty(tehNode, "five", (Object)"five");
        Map props = inserter.getNodeProperties(tehNode);
        Assert.assertEquals((long)5L, (long)props.size());
        Assert.assertEquals((Object)"one", props.get("one"));
        Assert.assertEquals((Object)"five", props.get("five"));
        inserter.shutdown();
    }

    @Test
    public void setSingleProperty() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long node = inserter.createNode(null);
        String value = "Something";
        String key = "name";
        inserter.setNodeProperty(node, key, (Object)value);
        GraphDatabaseService db = this.switchToEmbeddedGraphDatabaseService(inserter);
        Assert.assertEquals((Object)value, (Object)db.getNodeById(node).getProperty(key));
        db.shutdown();
    }

    private GraphDatabaseService switchToEmbeddedGraphDatabaseService(BatchInserter inserter) {
        inserter.shutdown();
        return new EmbeddedGraphDatabase(inserter.getStoreDir());
    }

    @Test
    public void testSetAndKeepNodeProperty() {
        BatchInserter inserter = this.newBatchInserter();
        long tehNode = inserter.createNode(MapUtil.map((Object[])new Object[]{"foo", "bar"}));
        inserter.setNodeProperty(tehNode, "foo2", (Object)"bar2");
        Map props = inserter.getNodeProperties(tehNode);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(false);
        props = inserter.getNodeProperties(tehNode);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.setNodeProperty(tehNode, "foo", (Object)"bar3");
        props = inserter.getNodeProperties(tehNode);
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(false);
        props = inserter.getNodeProperties(tehNode);
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
    }

    @Test
    public void testSetAndKeepRelationshipProperty() {
        BatchInserter inserter = this.newBatchInserter();
        long from = inserter.createNode(Collections.EMPTY_MAP);
        long to = inserter.createNode(Collections.EMPTY_MAP);
        long theRel = inserter.createRelationship(from, to, (RelationshipType)DynamicRelationshipType.withName((String)"TestingPropsHere"), MapUtil.map((Object[])new Object[]{"foo", "bar"}));
        inserter.setRelationshipProperty(theRel, "foo2", (Object)"bar2");
        Map props = inserter.getRelationshipProperties(theRel);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(false);
        props = inserter.getRelationshipProperties(theRel);
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.setRelationshipProperty(theRel, "foo", (Object)"bar3");
        props = inserter.getRelationshipProperties(theRel);
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
        inserter = this.newBatchInserter(false);
        props = inserter.getRelationshipProperties(theRel);
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((long)2L, (long)props.size());
        Assert.assertEquals((Object)"bar3", props.get("foo"));
        Assert.assertEquals((Object)"bar2", props.get("foo2"));
        inserter.shutdown();
    }

    @Test
    public void testNodeHasProperty() {
        BatchInserter inserter = this.newBatchInserter();
        long theNode = inserter.createNode(properties);
        long anotherNode = inserter.createNode(Collections.EMPTY_MAP);
        long relationship = inserter.createRelationship(theNode, anotherNode, (RelationshipType)DynamicRelationshipType.withName((String)"foo"), properties);
        for (String key : properties.keySet()) {
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key + "-"));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
            Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key + "-"));
        }
        inserter.shutdown();
    }

    @Test
    public void testRemoveProperties() {
        BatchInserter inserter = this.newBatchInserter();
        long theNode = inserter.createNode(properties);
        long anotherNode = inserter.createNode(Collections.EMPTY_MAP);
        long relationship = inserter.createRelationship(theNode, anotherNode, (RelationshipType)DynamicRelationshipType.withName((String)"foo"), properties);
        inserter.removeNodeProperty(theNode, "key0");
        inserter.removeRelationshipProperty(relationship, "key1");
        for (String key : properties.keySet()) {
            if (key.equals("key0")) {
                Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                continue;
            }
            if (key.equals("key1")) {
                Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                continue;
            }
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
        inserter = this.newBatchInserter(false);
        for (String key : properties.keySet()) {
            if (key.equals("key0")) {
                Assert.assertFalse((boolean)inserter.nodeHasProperty(theNode, key));
                Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
                continue;
            }
            if (key.equals("key1")) {
                Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
                Assert.assertFalse((boolean)inserter.relationshipHasProperty(relationship, key));
                continue;
            }
            Assert.assertTrue((boolean)inserter.nodeHasProperty(theNode, key));
            Assert.assertTrue((boolean)inserter.relationshipHasProperty(relationship, key));
        }
        inserter.shutdown();
    }

    @Test
    public void testMore() {
        BatchInserter graphDb = this.newBatchInserter();
        long startNode = graphDb.createNode(properties);
        long[] endNodes = new long[25];
        HashSet<Long> rels = new HashSet<Long>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = graphDb.createNode(properties);
            rels.add(graphDb.createRelationship(startNode, endNodes[i], relTypeArray[i % 5], properties));
        }
        for (BatchRelationship rel : graphDb.getRelationships(startNode)) {
            Assert.assertTrue((boolean)rels.contains(rel.getId()));
            Assert.assertEquals((long)rel.getStartNode(), (long)startNode);
        }
        graphDb.setNodeProperties(startNode, properties);
        graphDb.shutdown();
    }

    @Test
    public void testPropSetAndReset() {
        BatchInserter graphDb = this.newBatchInserter();
        BatchGraphDatabaseImpl gds = new BatchGraphDatabaseImpl(graphDb);
        long startNode = graphDb.createNode(properties);
        this.assertProperties(gds.getNodeById(startNode));
        graphDb.setNodeProperties(startNode, properties);
        this.assertProperties(gds.getNodeById(startNode));
        graphDb.setNodeProperties(startNode, properties);
        this.assertProperties(gds.getNodeById(startNode));
        gds.shutdown();
    }

    @Test
    public void makeSureLoopsCanBeCreated() {
        BatchInserter graphDb = this.newBatchInserter();
        long startNode = graphDb.createNode(properties);
        long otherNode = graphDb.createNode(properties);
        long selfRelationship = graphDb.createRelationship(startNode, startNode, relTypeArray[0], properties);
        long relationship = graphDb.createRelationship(startNode, otherNode, relTypeArray[0], properties);
        for (BatchRelationship rel : graphDb.getRelationships(startNode)) {
            if (rel.getId() == selfRelationship) {
                Assert.assertEquals((long)startNode, (long)rel.getStartNode());
                Assert.assertEquals((long)startNode, (long)rel.getEndNode());
                continue;
            }
            if (rel.getId() == relationship) {
                Assert.assertEquals((long)startNode, (long)rel.getStartNode());
                Assert.assertEquals((long)otherNode, (long)rel.getEndNode());
                continue;
            }
            Assert.fail((String)("Unexpected relationship " + rel.getId()));
        }
        String storeDir = ((BatchInserterImpl)graphDb).getStoreDir();
        graphDb.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        Node realStartNode = db.getNodeById(startNode);
        Relationship realSelfRelationship = db.getRelationshipById(selfRelationship);
        Relationship realRelationship = db.getRelationshipById(relationship);
        Assert.assertEquals((Object)realSelfRelationship, (Object)realStartNode.getSingleRelationship((RelationshipType)RelTypes.REL_TYPE1, Direction.INCOMING));
        Assert.assertEquals(TestBatchInsert.asSet(realSelfRelationship, realRelationship), TestBatchInsert.asSet(realStartNode.getRelationships(Direction.OUTGOING)));
        Assert.assertEquals(TestBatchInsert.asSet(realSelfRelationship, realRelationship), TestBatchInsert.asSet(realStartNode.getRelationships()));
        db.shutdown();
    }

    private static <T> Set<T> asSet(T ... items) {
        return new HashSet<T>(Arrays.asList(items));
    }

    private static <T> Set<T> asSet(Iterable<T> items) {
        return new HashSet(IteratorUtil.asCollection(items));
    }

    private void setProperties(Node node) {
        for (String key : properties.keySet()) {
            node.setProperty(key, properties.get(key));
        }
    }

    private void setProperties(Relationship rel) {
        for (String key : properties.keySet()) {
            rel.setProperty(key, properties.get(key));
        }
    }

    private void assertProperties(Node node) {
        for (String key : properties.keySet()) {
            if (properties.get(key).getClass().isArray()) {
                Class<?> component = properties.get(key).getClass().getComponentType();
                if (!component.isPrimitive()) {
                    Assert.assertTrue((boolean)Arrays.equals((Object[])properties.get(key), (Object[])node.getProperty(key)));
                    continue;
                }
                if (component == Integer.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((int[])properties.get(key), (int[])node.getProperty(key)));
                    continue;
                }
                if (component == Boolean.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((boolean[])properties.get(key), (boolean[])node.getProperty(key)));
                    continue;
                }
                if (component == Byte.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((byte[])properties.get(key), (byte[])node.getProperty(key)));
                    continue;
                }
                if (component == Character.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((char[])properties.get(key), (char[])node.getProperty(key)));
                    continue;
                }
                if (component == Long.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((long[])properties.get(key), (long[])node.getProperty(key)));
                    continue;
                }
                if (component == Float.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((float[])properties.get(key), (float[])node.getProperty(key)));
                    continue;
                }
                if (component == Double.TYPE) {
                    if (!component.isPrimitive()) continue;
                    Assert.assertTrue((boolean)Arrays.equals((double[])properties.get(key), (double[])node.getProperty(key)));
                    continue;
                }
                if (component != Short.TYPE || !component.isPrimitive()) continue;
                Assert.assertTrue((boolean)Arrays.equals((short[])properties.get(key), (short[])node.getProperty(key)));
                continue;
            }
            Assert.assertEquals((Object)properties.get(key), (Object)node.getProperty(key));
        }
        for (String stored : node.getPropertyKeys()) {
            Assert.assertTrue((boolean)properties.containsKey(stored));
        }
    }

    @Test
    public void testWithGraphDbService() {
        GraphDatabaseService graphDb = this.newBatchGraphDatabase();
        Node startNode = graphDb.createNode();
        this.setProperties(startNode);
        Node[] endNodes = new Node[25];
        HashSet<Relationship> rels = new HashSet<Relationship>();
        for (int i = 0; i < 25; ++i) {
            endNodes[i] = graphDb.createNode();
            this.setProperties(endNodes[i]);
            Relationship rel = startNode.createRelationshipTo(endNodes[i], relTypeArray[i % 5]);
            rels.add(rel);
            this.setProperties(rel);
        }
        for (Relationship rel : startNode.getRelationships()) {
            Assert.assertTrue((boolean)rels.contains(rel));
            Assert.assertEquals((Object)rel.getStartNode(), (Object)startNode);
        }
        this.setProperties(startNode);
        graphDb.shutdown();
    }

    @Test
    public void testGraphDbServiceGetRelationships() {
        Iterator relItr;
        int i;
        GraphDatabaseService graphDb = this.newBatchGraphDatabase();
        Node startNode = graphDb.createNode();
        for (i = 0; i < 5; ++i) {
            Node endNode = graphDb.createNode();
            startNode.createRelationshipTo(endNode, relTypeArray[i]);
        }
        for (i = 0; i < 5; ++i) {
            Assert.assertTrue((startNode.getSingleRelationship(relTypeArray[i], Direction.OUTGOING) != null ? 1 : 0) != 0);
        }
        for (i = 0; i < 5; ++i) {
            relItr = startNode.getRelationships(relTypeArray[i], Direction.OUTGOING).iterator();
            relItr.next();
            Assert.assertTrue((!relItr.hasNext() ? 1 : 0) != 0);
        }
        for (i = 0; i < 5; ++i) {
            relItr = startNode.getRelationships(new RelationshipType[]{relTypeArray[i]}).iterator();
            relItr.next();
            Assert.assertTrue((!relItr.hasNext() ? 1 : 0) != 0);
        }
        graphDb.shutdown();
    }

    @Test
    public void createBatchNodeAndRelationshipsDeleteAllInEmbedded() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        String storeDir = ((BatchInserterImpl)inserter).getStoreDir();
        long nodeId = inserter.createNode(null);
        inserter.createRelationship(nodeId, inserter.createNode(null), (RelationshipType)RelTypes.BATCH_TEST, null);
        inserter.createRelationship(inserter.createNode(null), nodeId, (RelationshipType)RelTypes.REL_TYPE1, null);
        inserter.shutdown();
        EmbeddedGraphDatabase db = new EmbeddedGraphDatabase(storeDir);
        Transaction tx = db.beginTx();
        Node node = db.getNodeById(nodeId);
        for (Relationship relationship : node.getRelationships()) {
            relationship.delete();
        }
        node.delete();
        tx.success();
        tx.finish();
        db.shutdown();
    }

    @Test
    public void messagesLogGetsClosed() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        String storeDir = inserter.getStoreDir();
        inserter.shutdown();
        Assert.assertTrue((boolean)new File(storeDir, "messages.log").delete());
    }

    @Test
    public void createEntitiesWithEmptyPropertiesMap() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[0]));
        inserter.getNodeProperties(nodeId);
        long anotherNodeId = inserter.createNode(null);
        long relId = inserter.createRelationship(nodeId, anotherNodeId, (RelationshipType)RelTypes.BATCH_TEST, MapUtil.map((Object[])new Object[0]));
        inserter.getRelationshipProperties(relId);
        inserter.shutdown();
    }

    @Test
    public void createEntitiesWithDynamicPropertiesMap() throws Exception {
        BatchInserter inserter = this.newBatchInserter();
        this.setAndGet(inserter, "http://www.w3.org/1999/02/22-rdf-syntax-ns#type");
        this.setAndGet(inserter, this.intArray(20));
        inserter.shutdown();
    }

    private void setAndGet(BatchInserter inserter, Object value) {
        long nodeId = inserter.createNode(MapUtil.map((Object[])new Object[]{"key", value}));
        Object readValue = inserter.getNodeProperties(nodeId).get("key");
        if (readValue.getClass().isArray()) {
            Assert.assertTrue((boolean)Arrays.equals((int[])value, (int[])readValue));
        } else {
            Assert.assertEquals((Object)value, readValue);
        }
    }

    private int[] intArray(int length) {
        int[] array = new int[length];
        int startValue = (int)Math.pow(2.0, 30.0);
        for (int i = 0; i < length; ++i) {
            array[i] = startValue + i;
        }
        return array;
    }

    static {
        properties.put("key0", "SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA");
        properties.put("key1", 1);
        properties.put("key2", (short)2);
        properties.put("key3", 3L);
        properties.put("key4", Float.valueOf(4.0f));
        properties.put("key5", 5.0);
        properties.put("key6", (byte)6);
        properties.put("key7", true);
        properties.put("key8", Character.valueOf('\b'));
        properties.put("key10", new String[]{"SDSDASSDLKSDSAKLSLDAKSLKDLSDAKLDSLA", "dsasda", "dssadsad"});
        properties.put("key11", new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key12", new short[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key13", new long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L});
        properties.put("key14", new float[]{1.0f, 2.0f, 3.0f, 4.0f, 5.0f, 6.0f, 7.0f, 8.0f, 9.0f});
        properties.put("key15", new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0});
        properties.put("key16", new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9});
        properties.put("key17", new boolean[]{true, false, true, false});
        properties.put("key18", new char[]{'\u0001', '\u0002', '\u0003', '\u0004', '\u0005', '\u0006', '\u0007', '\b', '\t'});
    }

    private static enum RelTypes implements RelationshipType
    {
        BATCH_TEST,
        REL_TYPE1,
        REL_TYPE2,
        REL_TYPE3,
        REL_TYPE4,
        REL_TYPE5;

    }
}

