/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.kernel.impl.util.FileUtils;

public class TargetDirectory {
    private final File base;

    private TargetDirectory(File base) {
        this.base = base.getAbsoluteFile();
    }

    public static void recursiveDelete(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File each : files) {
                TargetDirectory.recursiveDelete(each);
            }
        }
        file.delete();
    }

    public File directory(String name) {
        return this.directory(name, false);
    }

    public File directory(String name, boolean clean) {
        File dir = new File(this.base(), name);
        if (clean && dir.exists()) {
            TargetDirectory.recursiveDelete(dir);
        }
        dir.mkdir();
        return dir;
    }

    public File file(String name) {
        return new File(this.base(), name);
    }

    private File base() {
        if (this.base.exists()) {
            if (!this.base.isDirectory()) {
                throw new IllegalStateException(this.base + " exists and is not a directory!");
            }
        } else {
            this.base.mkdirs();
        }
        return this.base;
    }

    public TestDirectory testDirectory() {
        return new TestDirectory();
    }

    public static TargetDirectory forTest(Class<?> owningTest) {
        File target = null;
        try {
            File codeSource = new File(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (codeSource.exists() && !codeSource.isFile() && codeSource.isDirectory()) {
                target = codeSource.getParentFile();
            }
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        if (!(target != null || (target = new File("target")).exists() && target.isDirectory())) {
            try {
                target = File.createTempFile("neo4j-test", "target");
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot create target directory");
            }
        }
        return new TargetDirectory(new File(new File(target, "test-data"), owningTest.getName()));
    }

    public static TestDirectory testDirForTest(Class<?> owningTest) {
        return TargetDirectory.forTest(owningTest).testDirectory();
    }

    public File graphDbDir(boolean clean) {
        return this.directory("graph-db", clean);
    }

    public void cleanup() throws IOException {
        FileUtils.deleteRecursively((File)this.base);
    }

    public class TestDirectory
    implements TestRule {
        private File subdir = null;

        public File directory() {
            if (this.subdir == null) {
                throw new IllegalStateException("Not initialized");
            }
            return this.subdir;
        }

        public Statement apply(final Statement base, Description description) {
            this.subdir = TargetDirectory.this.directory(description.getMethodName());
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    boolean success = false;
                    try {
                        base.evaluate();
                        success = true;
                    }
                    finally {
                        TestDirectory.this.complete(success);
                    }
                }
            };
        }

        protected void complete(boolean success) {
            if (success && this.subdir != null) {
                TargetDirectory.recursiveDelete(this.subdir);
            }
            this.subdir = null;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + (this.subdir == null ? "<uninitialized>" : this.subdir.toString()) + "]";
        }
    }
}

