/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import com.google.gson.Gson;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.tooling.GlobalGraphOperations;

public class GeoffService {
    private final GraphDatabaseService gdb;

    public GeoffService(GraphDatabaseService gdb) {
        this.gdb = gdb;
    }

    private Map<String, Node> geoffNodeParams() {
        HashMap<String, Node> result = new HashMap<String, Node>();
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.gdb).getAllNodes()) {
            result.put("(" + node.getId() + ")", node);
        }
        return result;
    }

    public String toGeoff() {
        StringBuilder sb = new StringBuilder();
        this.appendNodes(sb);
        this.appendRelationships(sb);
        return sb.toString();
    }

    private void appendRelationships(StringBuilder sb) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.gdb).getAllNodes()) {
            for (Relationship rel : node.getRelationships(Direction.OUTGOING)) {
                this.formatNode(sb, rel.getStartNode());
                sb.append("-[:").append(rel.getType().name()).append("]->");
                this.formatNode(sb, rel.getEndNode());
                this.formatProperties(sb, (PropertyContainer)rel);
                sb.append("\n");
            }
        }
    }

    private void appendNodes(StringBuilder sb) {
        for (Node node : GlobalGraphOperations.at((GraphDatabaseService)this.gdb).getAllNodes()) {
            this.formatNode(sb, node);
            this.formatProperties(sb, (PropertyContainer)node);
            sb.append("\n");
        }
    }

    private void formatNode(StringBuilder sb, Node n) {
        sb.append("(").append(n.getId()).append(")");
    }

    private void formatProperties(StringBuilder sb, PropertyContainer pc) {
        sb.append(" ");
        sb.append(new Gson().toJson(this.toMap(pc)));
    }

    Map<String, Object> toMap(PropertyContainer pc) {
        TreeMap<String, Object> result = new TreeMap<String, Object>();
        for (String prop : pc.getPropertyKeys()) {
            result.put(prop, pc.getProperty(prop));
        }
        return result;
    }
}

