/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import org.junit.rules.ExternalResource;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.kernel.GraphDatabaseAPI;

public class EmbeddedDatabaseRule
extends ExternalResource {
    TemporaryFolder temp = new TemporaryFolder();
    GraphDatabaseAPI database;

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.shutdown();
    }

    public void create() throws IOException {
        this.temp.create();
        try {
            GraphDatabaseBuilder builder = new GraphDatabaseFactory().newEmbeddedDatabaseBuilder(this.temp.getRoot().getAbsolutePath());
            this.configure(builder);
            this.database = (GraphDatabaseAPI)builder.newGraphDatabase();
        }
        catch (RuntimeException e) {
            this.temp.delete();
            throw e;
        }
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.database;
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        return this.database;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            if (this.database != null) {
                this.database.shutdown();
            }
        }
        finally {
            this.temp.delete();
            this.database = null;
        }
    }
}

