/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.neo4j.graphdb.GraphDatabaseService;

public abstract class AsciiDocGenerator {
    private static final String DOCUMENTATION_END = "\n...\n";
    private Logger log = Logger.getLogger(AsciiDocGenerator.class.getName());
    protected final String title;
    protected String section;
    protected String description = null;
    protected GraphDatabaseService graph;
    protected static final String SNIPPET_MARKER = "@@";
    protected Map<String, String> snippets = new HashMap<String, String>();

    public AsciiDocGenerator(String title, String section) {
        this.section = section;
        this.title = title.replace("_", " ");
    }

    public AsciiDocGenerator setGraph(GraphDatabaseService graph) {
        this.graph = graph;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public AsciiDocGenerator setSection(String section) {
        this.section = section;
        return this;
    }

    public AsciiDocGenerator description(String description) {
        if (description == null) {
            throw new IllegalArgumentException("The description can not be null");
        }
        int pos = description.indexOf(DOCUMENTATION_END);
        String content = pos != -1 ? description.substring(0, pos) : description;
        this.description = this.description == null ? content : this.description + "\n\n" + content;
        return this;
    }

    protected void line(Writer fw, String string) throws IOException {
        fw.append(string);
        fw.append("\n");
    }

    public static Writer getFW(String dir, String title) {
        try {
            String name;
            File out;
            File dirs = new File(dir);
            if (!dirs.exists()) {
                dirs.mkdirs();
            }
            if ((out = new File(dirs, (name = title.replace(" ", "-").toLowerCase()) + ".txt")).exists()) {
                out.delete();
            }
            if (!out.createNewFile()) {
                throw new RuntimeException("File exists: " + out.getAbsolutePath());
            }
            return new OutputStreamWriter((OutputStream)new FileOutputStream(out, false), "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static PrintWriter getPrintWriter(String dir, String title) {
        return new PrintWriter(AsciiDocGenerator.getFW(dir, title));
    }

    public static String getPath(Class<?> source) {
        return source.getPackage().getName().replace(".", "/") + "/" + source.getSimpleName() + ".java";
    }

    protected String replaceSnippets(String description) {
        for (String key : this.snippets.keySet()) {
            description = this.replaceSnippet(description, key);
        }
        if (description.contains(SNIPPET_MARKER)) {
            int indexOf = description.indexOf(SNIPPET_MARKER);
            String snippet = description.substring(indexOf, description.indexOf("\n", indexOf));
            this.log.severe("missing snippet [" + snippet + "] in " + description);
        }
        return description;
    }

    private String replaceSnippet(String description, String key) {
        String snippetString = SNIPPET_MARKER + key;
        if (description.contains(snippetString + "\n")) {
            description = description.replace(snippetString + "\n", this.snippets.get(key));
        } else {
            this.log.severe("could not find " + snippetString + "\\n in " + description);
        }
        return description;
    }

    public void addSnippet(String key, String content) {
        this.snippets.put(key, content);
    }

    public void addTestSourceSnippets(Class<?> source, String ... tagNames) {
        for (String tagName : tagNames) {
            this.addSnippet(tagName, AsciiDocGenerator.sourceSnippet(tagName, source, "test-sources"));
        }
    }

    public void addSourceSnippets(Class<?> source, String ... tagNames) {
        for (String tagName : tagNames) {
            this.addSnippet(tagName, AsciiDocGenerator.sourceSnippet(tagName, source, "sources"));
        }
    }

    private static String sourceSnippet(String tagName, Class<?> source, String classifier) {
        return "[snippet,java]\n----\ncomponent=${project.artifactId}\nsource=" + AsciiDocGenerator.getPath(source) + "\n" + "classifier=" + classifier + "\n" + "tag=" + tagName + "\n" + "----\n";
    }

    public void addGithubTestSourceLink(String key, Class<?> source, String repo, String dir) {
        this.githubLink(key, source, repo, dir, "test");
    }

    public void addGithubSourceLink(String key, Class<?> source, String repo, String dir) {
        this.githubLink(key, source, repo, dir, "main");
    }

    private void githubLink(String key, Class<?> source, String repo, String dir, String mainOrTest) {
        String path = "https://github.com/" + repo + "/blob/{neo4j-git-tag}/";
        if (dir != null) {
            path = path + dir + "/";
        }
        path = path + "src/" + mainOrTest + "/java/" + AsciiDocGenerator.getPath(source);
        path = path + "[" + source.getSimpleName() + ".java]\n";
        this.addSnippet(key, path);
    }
}

