/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.metatest;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.kernel.impl.annotations.Documented;
import org.neo4j.test.GraphDescription;
import org.neo4j.test.GraphHolder;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.neo4j.test.JavaTestDocsGenerator;
import org.neo4j.test.TestData;

public class TestJavaTestDocsGenerator
implements GraphHolder {
    private static GraphDatabaseService graphdb;
    @Rule
    public TestData<Map<String, Node>> data = TestData.producedThrough(GraphDescription.createGraphFor(this, true));
    @Rule
    public TestData<JavaTestDocsGenerator> gen = TestData.producedThrough(JavaTestDocsGenerator.PRODUCER);
    String directory = "target" + File.separator + "testdocs";
    String sectionName = "testsection";

    @Documented(value="Title1.\n\nhej\n@@snippet1\n\nmore docs\n@@snippet_2-1\n@@snippet12\n.")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void can_create_docs_from_method_name() throws Exception {
        this.data.get();
        JavaTestDocsGenerator doc = this.gen.get();
        doc.setGraph(graphdb);
        Assert.assertNotNull((Object)this.data.get().get("I"));
        String snippet1 = "snippet1-value";
        String snippet12 = "snippet12-value";
        String snippet2 = "snippet2-value";
        doc.addSnippet("snippet1", snippet1);
        doc.addSnippet("snippet12", snippet12);
        doc.addSnippet("snippet_2-1", snippet2);
        doc.document(this.directory, this.sectionName);
        String result = TestJavaTestDocsGenerator.readFileAsString(new File("target/testdocs/testsection/title1.txt"));
        Assert.assertTrue((boolean)result.contains(snippet1));
        Assert.assertTrue((boolean)result.contains(snippet12));
        Assert.assertTrue((boolean)result.contains(snippet2));
    }

    @Documented(value="@@snippet1\n")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void will_not_complain_about_missing_snippets() throws Exception {
        this.data.get();
        JavaTestDocsGenerator doc = this.gen.get();
        doc.document(this.directory, this.sectionName);
    }

    @Documented(value=" Title2.\n \n @@snippet1\n \n            more stuff\n \n \n @@snippet2\n")
    @Test
    @GraphDescription.Graph(value={"I know you"})
    public void canCreateDocsFromSnippetsInAnnotations() throws Exception {
        this.data.get();
        JavaTestDocsGenerator doc = this.gen.get();
        doc.setGraph(graphdb);
        Assert.assertNotNull((Object)this.data.get().get("I"));
        String snippet1 = "snippet1-value";
        String snippet2 = "snippet2-value";
        doc.addSnippet("snippet1", snippet1);
        doc.addSnippet("snippet2", snippet2);
        doc.document(this.directory, this.sectionName);
        String result = TestJavaTestDocsGenerator.readFileAsString(new File("target/testdocs/testsection/title2.txt"));
        Assert.assertTrue((boolean)result.contains(snippet1));
        Assert.assertTrue((boolean)result.contains(snippet2));
    }

    private static String readFileAsString(File file) throws IOException {
        byte[] buffer = new byte[(int)file.length()];
        BufferedInputStream f = new BufferedInputStream(new FileInputStream(file));
        f.read(buffer);
        return new String(buffer);
    }

    @Override
    public GraphDatabaseService graphdb() {
        return graphdb;
    }

    @BeforeClass
    public static void setUp() {
        graphdb = new ImpermanentGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterClass
    public static void shutdown() {
        try {
            if (graphdb != null) {
                graphdb.shutdown();
            }
        }
        finally {
            graphdb = null;
        }
    }
}

